/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.handlers.fakews;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.nuxeo.wss.WSSException;
import org.nuxeo.wss.fm.FreeMarkerRenderer;
import org.nuxeo.wss.handlers.fakews.FakeWSCmdParser;
import org.nuxeo.wss.handlers.fakews.FakeWSHandler;
import org.nuxeo.wss.handlers.fakews.FakeWSRequest;
import org.nuxeo.wss.servlet.WSSResponse;
import org.nuxeo.wss.spi.Backend;
import org.nuxeo.wss.spi.WSSBackend;
import org.nuxeo.wss.spi.WSSListItem;
import org.nuxeo.wss.spi.dws.DWSDocument;
import org.nuxeo.wss.spi.dws.DWSMetaData;
import org.nuxeo.wss.spi.dws.Link;
import org.nuxeo.wss.spi.dws.Task;
import org.nuxeo.wss.spi.dws.User;

public class FakeDWS
implements FakeWSHandler {
    public static final String document_TAG = "document";
    public static final String url_TAG = "url";

    @Override
    public void handleRequest(FakeWSRequest request, WSSResponse response) throws WSSException {
        response.addRenderingParameter("siteRoot", request.getSitePath());
        response.addRenderingParameter("request", request);
        if ("http://schemas.microsoft.com/sharepoint/soap/dws/GetDwsMetaData".equals(request.getAction()) || "http://schemas.microsoft.com/sharepoint/soap/dws/GetDwsData".equals(request.getAction())) {
            boolean withMeta = true;
            if ("http://schemas.microsoft.com/sharepoint/soap/dws/GetDwsData".equals(request.getAction())) {
                withMeta = false;
            }
            String documentUrl = null;
            try {
                documentUrl = new FakeWSCmdParser(document_TAG).getParameter(request);
                documentUrl = URLDecoder.decode(documentUrl, "UTF-8");
            }
            catch (Exception e) {
                throw new WSSException("Error parsing envelope", e);
            }
            response.setContentType("text/xml");
            String subPath = documentUrl.replace(request.getBaseUrl(), "");
            WSSBackend backend = Backend.get(request);
            WSSListItem item = backend.getItem(subPath);
            DWSMetaData metadata = backend.getMetaData(subPath, request);
            List<User> users = metadata.getUsers();
            List<Task> tasks = metadata.getTasks();
            List<Link> links = metadata.getLinks();
            ArrayList<User> assignees = new ArrayList<User>();
            ArrayList<DWSDocument> docs = new ArrayList<DWSDocument>();
            block6: for (Task task : tasks) {
                String login = task.getAssigneeLogin();
                for (User user : users) {
                    if (!user.getLogin().equals(login)) continue;
                    assignees.add(user);
                    continue block6;
                }
            }
            for (Task task : tasks) {
                task.updateReferences(users, assignees);
            }
            for (Link link : links) {
                link.updateReferences(users);
            }
            int docIdx = 1;
            String siteRoot = this.calculateSiteRoot(request);
            for (WSSListItem doc : metadata.getDocuments()) {
                DWSDocument dwsd = new DWSDocument(doc, siteRoot);
                dwsd.updateReferences(users);
                dwsd.setId(String.valueOf(docIdx));
                docs.add(dwsd);
                ++docIdx;
            }
            String siteUrl = metadata.getSite().getItem().getRelativeSubPath(siteRoot);
            HashMap<String, Object> renderingContext = new HashMap<String, Object>();
            renderingContext.put("doc", item);
            renderingContext.put("request", request);
            renderingContext.put("tasks", tasks);
            renderingContext.put("docs", docs);
            renderingContext.put("links", links);
            renderingContext.put("users", users);
            renderingContext.put("assignees", assignees);
            renderingContext.put("currentUser", metadata.getCurrentUser());
            renderingContext.put("site", metadata.getSite());
            renderingContext.put("updateTS", System.currentTimeMillis() + "");
            renderingContext.put("siteRoot", siteRoot);
            renderingContext.put("siteUrl", siteUrl);
            try {
                String xmlMetaData = "";
                xmlMetaData = withMeta ? this.renderSubTemplate("GetDwsMetaDataBody.ftl", renderingContext) : this.renderSubTemplate("GetDwsDataBody.ftl", renderingContext);
                xmlMetaData = StringEscapeUtils.escapeXml((String)xmlMetaData);
                response.addRenderingParameter("doc", item);
                response.addRenderingParameter("xmlMetaData", xmlMetaData);
                if (withMeta) {
                    response.setRenderingTemplateName("GetDwsMetaData.ftl");
                }
                response.setRenderingTemplateName("GetDwsData.ftl");
            }
            catch (Exception e) {
                throw new WSSException("Error while rendering sub template", e);
            }
        } else if ("http://schemas.microsoft.com/sharepoint/soap/dws/CreateFolder".equals(request.getAction())) {
            String targetPath;
            String folderName;
            String documentUrl;
            try {
                documentUrl = new FakeWSCmdParser(url_TAG).getParameter(request);
                documentUrl = URLDecoder.decode(documentUrl, "UTF-8");
            }
            catch (Exception e) {
                throw new WSSException("Error parsing envelope", e);
            }
            response.setContentType("text/xml");
            String siteRoot = this.calculateSiteRoot(request);
            int idx = documentUrl.lastIndexOf("/");
            if (idx > 0) {
                folderName = documentUrl.substring(idx + 1);
                targetPath = siteRoot + "/" + documentUrl.substring(0, idx);
            } else {
                folderName = documentUrl;
                targetPath = siteRoot;
            }
            WSSBackend backend = Backend.get(request);
            backend.createFolder(targetPath, folderName);
            response.setRenderingTemplateName("CreateFolderResponse.ftl");
        } else {
            throw new WSSException("no FakeWS implemented for action " + request.getAction());
        }
    }

    protected String renderSubTemplate(String renderingTemplateName, Map<String, Object> renderingContext) throws Exception {
        ByteArrayOutputStream bufferedOs = new ByteArrayOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(bufferedOs));
        FreeMarkerRenderer.instance().render(renderingTemplateName, renderingContext, writer);
        ((Writer)writer).flush();
        ((Writer)writer).close();
        return bufferedOs.toString("UTF-8");
    }

    protected String calculateSiteRoot(FakeWSRequest request) {
        String siteRoot = request.getSitePath();
        if (siteRoot == null || siteRoot.equals("")) {
            siteRoot = request.getHttpRequest().getContextPath();
        }
        if (siteRoot == null) {
            siteRoot = System.getProperty("org.nuxeo.ecm.contextPath", "/nuxeo");
        }
        if (!siteRoot.startsWith("/")) {
            siteRoot = "/" + siteRoot;
        }
        if (siteRoot.endsWith("/")) {
            siteRoot = siteRoot.substring(0, siteRoot.length() - 1);
        }
        return siteRoot;
    }
}

