/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.requestcontroller.filter;

import com.thetransactioncompany.cors.CORSFilter;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.platform.web.common.requestcontroller.service.RequestControllerManager;
import org.nuxeo.runtime.api.Framework;

public class NuxeoCorsFilter
extends CORSFilter {
    public static final String FRAME_OPTIONS_HEADER = "X-Frame-Options";
    public static final String FRAME_OPTIONS_DEFAULT = "";
    public static final String FRAME_OPTIONS_PROPERTY = "nuxeo.frame.options";
    public String frameOptions = Framework.getProperty((String)"nuxeo.frame.options", (String)"");

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        FilterConfig filterConfig;
        if (response instanceof HttpServletResponse && !StringUtils.isBlank((String)this.frameOptions)) {
            ((HttpServletResponse)response).setHeader(FRAME_OPTIONS_HEADER, this.frameOptions);
        }
        if ((filterConfig = this.getFilterConfigFrom(request)) != null) {
            super.init(filterConfig);
            super.doFilter(request, response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    protected FilterConfig getFilterConfigFrom(ServletRequest request) {
        if (!(request instanceof HttpServletRequest)) {
            return null;
        }
        return ((RequestControllerManager)Framework.getLocalService(RequestControllerManager.class)).getCorsConfigForRequest((HttpServletRequest)request);
    }
}

