/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.session;

import java.util.Date;

public class SessionInfo
implements Comparable<SessionInfo> {
    protected final String sessionId;
    protected final long creationTime;
    protected long lastAccessTime = this.creationTime = System.currentTimeMillis();
    protected int nbAccess = 0;
    protected String lastAccessUrl;
    protected String loginName;

    public SessionInfo(String sid) {
        this.sessionId = sid;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void updateLastAccessTime() {
        this.lastAccessTime = System.currentTimeMillis();
    }

    public String getLastAccessUrl() {
        return this.lastAccessUrl;
    }

    public void setLastAccessUrl(String lastAccessUrl) {
        this.lastAccessUrl = lastAccessUrl;
        ++this.nbAccess;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public long getDurationInS() {
        return (System.currentTimeMillis() - this.creationTime) / 1000L;
    }

    public long getInactivityInS() {
        return (System.currentTimeMillis() - this.lastAccessTime) / 1000L;
    }

    protected String formatDuration(long nbs) {
        StringBuffer sb = new StringBuffer();
        long nbh = nbs / 3600L;
        long nbm = (nbs -= nbh * 3600L) / 60L;
        nbs -= nbm * 60L;
        if (nbh > 0L) {
            sb.append(nbh);
            sb.append("h ");
        }
        if (nbm > 0L || nbh > 0L) {
            sb.append(nbm);
            sb.append("m ");
        }
        sb.append(nbs);
        sb.append("s ");
        return sb.toString();
    }

    public String getDurationAsString() {
        return this.formatDuration(this.getDurationInS());
    }

    public String getInactivityAsString() {
        return this.formatDuration(this.getInactivityInS());
    }

    public Date getLastAccessDate() {
        return new Date(this.getLastAccessTime());
    }

    @Override
    public int compareTo(SessionInfo o) {
        if (this.getInactivityInS() == o.getInactivityInS()) {
            return 0;
        }
        return this.getInactivityInS() > o.getInactivityInS() ? 1 : -1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Sid=");
        sb.append(this.sessionId);
        sb.append(" : login=");
        sb.append(this.loginName);
        return sb.toString();
    }

    public int getAccessedPagesCount() {
        return this.nbAccess;
    }
}

