/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.commandline.executor.service.executors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.service.CommandLineDescriptor;
import org.nuxeo.ecm.platform.commandline.executor.service.executors.Executor;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractExecutor
implements Executor {
    @Deprecated
    public static final Pattern VALID_PARAMETER_PATTERN = Pattern.compile("[\\p{L}_0-9-.%:=/\\\\ ]+");

    public static boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName.toLowerCase().contains("windows");
    }

    public static String getParametersString(CommandLineDescriptor cmdDesc, CmdParameters params) {
        String paramString = cmdDesc.getParametersString();
        paramString = AbstractExecutor.replaceParams(params, paramString);
        return paramString;
    }

    public static String[] getParametersArray(CommandLineDescriptor cmdDesc, CmdParameters params) {
        String[] paramsArray;
        ArrayList<String> res = new ArrayList<String>();
        for (String paramString : paramsArray = cmdDesc.getParametersString().split(" ")) {
            res.add(AbstractExecutor.replaceParams(params, paramString));
        }
        return res.toArray(new String[0]);
    }

    private static String replaceParams(CmdParameters params, String paramString) {
        CommandLineExecutorService commandLineExecutorService = (CommandLineExecutorService)Framework.getLocalService(CommandLineExecutorService.class);
        HashMap<String, CmdParameters.CmdParameter> paramsValues = params.getCmdParameters();
        for (String pname : paramsValues.keySet()) {
            String param = "#{" + pname + "}";
            if (!paramString.contains(param)) continue;
            CmdParameters.CmdParameter cmdParameter = paramsValues.get(pname);
            String value = cmdParameter.getValue();
            commandLineExecutorService.checkParameter(value);
            paramString = paramString.replace("#{" + pname + "}", String.format("\"%s\"", value));
        }
        return paramString;
    }
}

