/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.property;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.regex.RegExHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.property.CSSPropertyEnum;
import com.phloc.css.property.ECSSProperty;
import com.phloc.css.utils.CSSNumberHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CSSPropertyEnumOrNumbers
extends CSSPropertyEnum {
    private final boolean m_bWithPercentage;
    private final int m_nMinNumbers;
    private final int m_nMaxNumbers;

    public CSSPropertyEnumOrNumbers(@Nonnull ECSSProperty eCSSProperty, boolean bl, @Nonnegative int n, @Nonnegative int n2, String ... stringArray) {
        super(eCSSProperty, stringArray);
        if (n < 0) {
            throw new IllegalArgumentException("minNumbers: " + n);
        }
        if (n2 < 0 || n2 < n) {
            throw new IllegalArgumentException("maxNumbers: " + n2);
        }
        this.m_bWithPercentage = bl;
        this.m_nMinNumbers = n;
        this.m_nMaxNumbers = n2;
    }

    public CSSPropertyEnumOrNumbers(@Nonnull ECSSProperty eCSSProperty, boolean bl, @Nonnegative int n, @Nonnegative int n2, @Nonnull @Nonempty Iterable<String> iterable) {
        super(eCSSProperty, iterable);
        if (n < 0) {
            throw new IllegalArgumentException("minNumbers: " + n);
        }
        if (n2 < 0 || n2 < n) {
            throw new IllegalArgumentException("maxNumbers: " + n2);
        }
        this.m_bWithPercentage = bl;
        this.m_nMinNumbers = n;
        this.m_nMaxNumbers = n2;
    }

    @Override
    public boolean isValidValue(@Nullable String string) {
        if (string == null) {
            return false;
        }
        String[] stringArray = RegExHelper.getSplitToArray((CharSequence)string.trim(), (String)"\\s+");
        if (stringArray.length < this.m_nMinNumbers || stringArray.length > this.m_nMaxNumbers) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
            if (super.isValidValue(stringArray[i]) || CSSNumberHelper.isValueWithUnit(stringArray[i], this.m_bWithPercentage)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    public CSSPropertyEnumOrNumbers getClone(@Nonnull ECSSProperty eCSSProperty) {
        return new CSSPropertyEnumOrNumbers(eCSSProperty, this.m_bWithPercentage, this.m_nMinNumbers, this.m_nMaxNumbers, this.m_aEnumValues);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("withPercentage", this.m_bWithPercentage).append("minNumbers", this.m_nMinNumbers).append("maxNumbers", this.m_nMaxNumbers).toString();
    }
}

