/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.jwt.service;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import java.io.UnsupportedEncodingException;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.ClientException;

@XObject(value="token")
public class TokenDescriptor {
    @XNode(value="@id")
    private String id;
    @XNode(value="@name")
    private String name;
    @XNode(value="@key")
    private String key;
    @XNode(value="@duration")
    private String duration;
    private JWTVerifier verifier;
    private Algorithm algorithm;

    public TokenDescriptor() {
    }

    public TokenDescriptor(TokenDescriptor algorithmDescriptor) {
        this.id = algorithmDescriptor.id;
        this.name = algorithmDescriptor.name;
        this.key = algorithmDescriptor.key;
        this.duration = algorithmDescriptor.duration;
    }

    public String getId() {
        return this.id;
    }

    public Algorithm getAlgorithm() {
        if (this.algorithm == null) {
            try {
                switch (this.name) {
                    case "HS256": {
                        this.algorithm = Algorithm.HMAC256((String)this.key);
                        break;
                    }
                    case "HS384": {
                        this.algorithm = Algorithm.HMAC384((String)this.key);
                        break;
                    }
                    case "HS512": {
                        this.algorithm = Algorithm.HMAC512((String)this.key);
                        break;
                    }
                    default: {
                        throw new ClientException("aucun algorithme correspondant \u00e0 " + this.name);
                    }
                }
            }
            catch (UnsupportedEncodingException | IllegalArgumentException e) {
                throw new ClientException((Throwable)e);
            }
        }
        return this.algorithm;
    }

    public JWTVerifier getJWTVerifier() {
        if (this.verifier == null) {
            this.verifier = JWT.require((Algorithm)this.getAlgorithm()).build();
        }
        return this.verifier;
    }

    public String getDuration() {
        return this.duration;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }
}

