/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.lang.reflect.Method;
import net.bull.javamelody.JpaMethod;
import net.bull.javamelody.JpaNamingStrategy;

public class JpaDefaultNamingStrategy
implements JpaNamingStrategy {
    @Override
    public String getRequestName(JpaMethod jpaMethod, Method javaMethod, Object[] args) {
        switch (jpaMethod) {
            case CREATE_QUERY: 
            case CREATE_NAMED_QUERY: 
            case CREATE_NATIVE_QUERY: 
            case CREATE_STORED_PROCEDURE_QUERY: 
            case CREATE_NAMED_STORED_PROCEDURE_QUERY: {
                return this.getQueryRequestName(javaMethod, args);
            }
            case FIND: {
                return this.getMethodWithClassArgRequestName(javaMethod, args);
            }
            case MERGE: 
            case PERSIST: 
            case REFRESH: 
            case REMOVE: 
            case DETACH: 
            case LOCK: {
                return this.getMethodWithEntityArgRequestName(javaMethod, args);
            }
            case FLUSH: {
                return this.getNoArgsRequestName(javaMethod);
            }
        }
        return this.getOtherRequestName(javaMethod, args);
    }

    protected String getOtherRequestName(Method javaMethod, Object[] args) {
        int argsLen = args == null ? 0 : args.length;
        return "other: " + javaMethod.getName() + "(?" + argsLen + "?)";
    }

    protected String getQueryRequestName(Method javaMethod, Object[] args) {
        StringBuilder requestName = new StringBuilder();
        String methodName = javaMethod.getName();
        requestName.append(methodName, "create".length(), methodName.length());
        this.appendArgs(requestName, args);
        return requestName.toString();
    }

    protected String getMethodWithClassArgRequestName(Method javaMethod, Object[] args) {
        String requestName = javaMethod.getName() + '(' + ((Class)args[0]).getSimpleName() + ')';
        return requestName;
    }

    protected String getMethodWithEntityArgRequestName(Method javaMethod, Object[] args) {
        String requestName = javaMethod.getName() + '(' + args[0].getClass().getSimpleName() + ')';
        return requestName;
    }

    protected String getNoArgsRequestName(Method javaMethod) {
        return javaMethod.getName() + "()";
    }

    protected void appendArgs(StringBuilder requestName, Object[] args) {
        requestName.append('(');
        if (args != null) {
            String separator = "";
            for (Object arg : args) {
                requestName.append(separator);
                separator = ", ";
                if (arg instanceof Class) {
                    requestName.append(((Class)arg).getSimpleName());
                    continue;
                }
                requestName.append(arg);
            }
        }
        requestName.append(')');
    }
}

