/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;

@Operation(id="Document.AddComplexProperty", category="Document", label="Add Complex Property", description="Create an entry in a complex property value on the input document. The property is specified using its xpath. The document is automatically saved if 'save' parameter is true. If you unset the 'save' you need to save it later using Save Document operation. Return the modified document.")
public class AddComplexProperty {
    public static final String ID = "Document.AddComplexProperty";
    @Context
    protected CoreSession session;
    @Param(name="xpath")
    protected String xpath;
    @Param(name="value")
    protected Properties value;
    @Param(name="save", required=false, values={"true"})
    protected boolean save = true;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) throws Exception {
        Serializable value2;
        Property property = doc.getProperty(this.xpath);
        if (property != null) {
            value2 = property.getValue();
            if (!(value2 instanceof Serializable) || !(value2 instanceof List)) {
                throw new DocumentException("the value is not a Serializable List " + this.value);
            }
        } else {
            throw new DocumentException("no property with name " + property);
        }
        List complexList = (List)((Object)value2);
        complexList.add(new HashMap(this.value));
        doc.setPropertyValue(this.xpath, (Serializable)((Object)complexList));
        if (this.save) {
            doc = this.session.saveDocument(doc);
        }
        return doc;
    }
}

