/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;

@Operation(id="Document.CopyACLs", category="Document", label="Copy the ACLs", description="Copy the ACLs from one source document to the input document. Return the input document.")
public class CopyACLs {
    public static final String ID = "Document.CopyACLs";
    @Context
    protected CoreSession session;
    @Param(name="the source document", required=true)
    protected DocumentModel srcDoc;
    @Param(name="ACL name list (comma separated)", required=false)
    protected String ACLnames;
    @Param(name="Copy all ACLs", required=false)
    protected boolean doCopyAll = false;
    @Param(name="Overwrite", required=false)
    protected boolean doOverwrite = false;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) throws Exception {
        if (null != this.srcDoc) {
            this.copyACP(doc.getRef());
        }
        return this.session.getDocument(doc.getRef());
    }

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentRef docRef) throws Exception {
        if (null != this.srcDoc) {
            this.copyACP(docRef);
        }
        return this.session.getDocument(docRef);
    }

    private void copyACP(DocumentRef docRef) throws ClientException {
        List<Object> aclsToCopyList = Collections.emptyList();
        ACP srcACP = this.session.getACP(this.srcDoc.getRef());
        if (!this.doCopyAll && StringUtils.isNotBlank((String)this.ACLnames)) {
            aclsToCopyList = Arrays.asList(this.ACLnames.split(","));
        }
        ACPImpl dstACP = new ACPImpl();
        for (ACL srcAcl : srcACP.getACLs()) {
            if (!this.doCopyAll && (this.doCopyAll || !aclsToCopyList.contains(srcAcl.getName()))) continue;
            dstACP.addACL(srcAcl);
        }
        this.session.setACP(docRef, (ACP)dstACP, this.doOverwrite);
    }
}

