/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsoup.Jsoup;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.PropertyException;

@Operation(id="TextExtraction.Operation", category="Conversion", label="Text extraction operation", description="Operation to extract plain text from fields. For HTLM text, format_in must contain html for escaping. ")
public class TextExtraction {
    public static final String ID = "TextExtraction.Operation";
    public static final Log log = LogFactory.getLog(TextExtraction.class);
    @Context
    protected CoreSession session;
    @Param(name="xpath_in", required=true)
    protected String xpath_in;
    @Param(name="format_in", required=false)
    protected String format_in;
    @Param(name="xpath_out", required=true)
    protected String xpath_out;
    @Param(name="nb_chars_out", required=true)
    protected int nb_chars_out;
    @Param(name="override", required=false)
    protected boolean override = true;

    @OperationMethod
    public DocumentModel run(DocumentModel doc) throws PropertyException, ClientException {
        String input = (String)((Object)doc.getPropertyValue(this.xpath_in));
        if (input == null) {
            return doc;
        }
        String output = (String)((Object)doc.getPropertyValue(this.xpath_out));
        boolean hasContent = output != null && output.length() > 0;
        String extraction = input;
        if ("html".equals(this.format_in)) {
            extraction = Jsoup.parse((String)extraction).text();
        }
        if (extraction.length() > this.nb_chars_out) {
            while (extraction.length() > this.nb_chars_out - 3 && extraction.lastIndexOf(32) != -1) {
                extraction = extraction.substring(0, extraction.lastIndexOf(32));
            }
            if (extraction.length() <= this.nb_chars_out - 3) {
                extraction = extraction + "...";
            }
        }
        if (this.override || !hasContent) {
            doc.setPropertyValue(this.xpath_out, (Serializable)((Object)extraction));
        }
        return doc;
    }
}

