/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation.security;

import fr.toutatice.ecm.platform.automation.security.ACEsOperationHelper;
import java.util.Collection;
import java.util.List;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;

public abstract class AbstractACEsOperation {
    protected DocumentModel execute(OperationContext ctx, CoreSession session, DocumentModel document, String aclName, Properties aces, boolean blockInheritance) throws Exception {
        List<ACE> inputACEs = ACEsOperationHelper.buildACEs(ctx, aces);
        ACP acp = document.getACP();
        if ("local".equals(aclName)) {
            ACL localAcl = acp.getOrCreateACL("local");
            if (blockInheritance) {
                localAcl = this.blockLocalACLIfNecessary(session, document, localAcl);
                localAcl = this.modifyACEs(localAcl, inputACEs);
                acp.addACL(localAcl);
            } else {
                acp = this.restoreInheritanceIfNecessary(session, document, localAcl);
                localAcl = this.modifyACEs(acp.getACL("local"), inputACEs);
                acp.addACL(localAcl);
            }
        } else {
            if ("inherited".equals(aclName)) {
                throw new Exception("You can not alter inherited ACL.");
            }
            ACL acl = acp.getOrCreateACL(aclName);
            acl = this.modifyACEs(acl, inputACEs);
        }
        document.setACP(acp, true);
        return document;
    }

    protected DocumentModel execute(CoreSession session, DocumentModel document, String aclName) throws Exception {
        ACP acp = document.getACP();
        acp.removeACL(aclName);
        document.setACP(acp, true);
        return document;
    }

    protected abstract ACL modifyACEs(ACL var1, List<ACE> var2);

    protected ACL blockLocalACLIfNecessary(CoreSession session, DocumentModel document, ACL localAcl) {
        ACE blockInhACe = ACEsOperationHelper.getBlockInheritanceACe();
        if (!localAcl.contains((Object)blockInhACe)) {
            ACL defaultLocalACL = ACEsOperationHelper.buildDefaultLocalACL(session, document);
            for (ACE ace : defaultLocalACL) {
                if (localAcl.contains((Object)ace)) continue;
                localAcl.add((Object)ace);
            }
            localAcl.add((Object)blockInhACe);
        }
        return localAcl;
    }

    protected ACP restoreInheritanceIfNecessary(CoreSession session, DocumentModel document, ACL localAcl) {
        ACE blockInACe;
        ACP acp = document.getACP();
        ACL defaultLocalACL = ACEsOperationHelper.buildDefaultLocalACL(session, document);
        if (localAcl.containsAll((Collection)defaultLocalACL)) {
            localAcl.removeAll((Collection)defaultLocalACL);
        }
        if (localAcl.contains((Object)(blockInACe = ACEsOperationHelper.getBlockInheritanceACe()))) {
            localAcl.remove((Object)blockInACe);
        }
        acp.addACL(localAcl);
        return acp;
    }
}

