/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation.transaction;

import fr.toutatice.ecm.platform.automation.transaction.TransactionalConversation;
import fr.toutatice.ecm.platform.automation.transaction.TransactionalConversationPool;
import fr.toutatice.ecm.platform.automation.transaction.TransactionsSupervisor;
import java.security.Principal;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.SystemException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.core.api.local.ClientLoginModule;
import org.nuxeo.ecm.core.api.local.LoginStack;
import org.nuxeo.elasticsearch.listener.ElasticSearchInlineListener;

public class TransactionalConversationManager {
    private static final Log log = LogFactory.getLog(TransactionalConversationManager.class);
    private static final String TXC_ID_PREFIX = "TXC-";
    private static TransactionalConversationManager instance;
    private TransactionalConversationPool txPool = new TransactionalConversationPool();
    private ExecutorService supervisorExecutor = Executors.newSingleThreadExecutor();
    private long txCounter = 0L;

    private TransactionalConversationManager() {
        this.supervisorExecutor.submit(new TransactionsSupervisor(this));
    }

    public static synchronized TransactionalConversationManager getInstance() {
        if (instance == null) {
            instance = new TransactionalConversationManager();
        }
        return instance;
    }

    public String start(Principal principal, String repositoryName) throws SystemException {
        String txcId = null;
        ExecutorService executor = Executors.newSingleThreadExecutor();
        LoginStack.Entry loginStack = ClientLoginModule.getThreadLocalLogin().peek();
        TransactionalConversation txConv = new TransactionalConversation(principal, repositoryName, executor, loginStack);
        Future<Object> future = txConv.getExecutor().submit(txConv);
        try {
            future.get();
            txcId = this.getTxcId(this.txCounter);
            ++this.txCounter;
            txConv.setTxcId(txcId);
            this.txPool.put(txcId, txConv);
            TransactionsSupervisor.addConversation(txcId);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new SystemException();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            throw new SystemException();
        }
        return txcId;
    }

    public Object notify(String txId, Object ctx, Object opId, Object params) throws InterruptedException {
        TransactionalConversation txConv = this.getTxConv(txId);
        if (txConv != null) {
            if (ctx != null) {
                String schemas;
                OperationContext reqOperationContext = (OperationContext)ctx;
                ConcurrentHashMap<String, String> threadContextVars = new ConcurrentHashMap<String, String>(reqOperationContext.getVars());
                threadContextVars.put("contextType", "transaction");
                HttpServletRequest httpRequest = (HttpServletRequest)reqOperationContext.get((Object)"request");
                if (httpRequest != null && (schemas = httpRequest.getHeader("X-NXDocumentProperties")) != null) {
                    threadContextVars.put("X-NXDocumentProperties", schemas);
                }
                OperationContext threadOperationContext = new OperationContext(reqOperationContext.getCoreSession(), threadContextVars);
                threadOperationContext.setInput(reqOperationContext.getInput());
                threadOperationContext.setCommit(false);
                txConv.setOperationContext(threadOperationContext);
            } else {
                txConv.setOperationContext(null);
            }
            txConv.setParams((Map)params);
            txConv.setOperationId((String)opId);
            txConv.setESSync((Boolean)ElasticSearchInlineListener.useSyncIndexing.get());
            Future<Object> future = txConv.getExecutor().submit(txConv);
            try {
                Object resultat = future.get();
                if (StringUtils.equals((String)"Repository.CommitOrRollbackTransaction", (String)((String)opId))) {
                    this.stopThread(txId);
                }
                return resultat;
            }
            catch (ExecutionException e) {
                throw new InterruptedException("Exception occured");
            }
        }
        log.error((Object)("No transaction found with this transaction id:" + txId));
        return null;
    }

    public TransactionalConversation get(String txId) {
        return (TransactionalConversation)this.txPool.get(txId);
    }

    protected void forceRollback(String txId) {
        try {
            this.notify(txId, null, "Repository.MarkTransactionAsRollback", null);
            this.notify(txId, null, "Repository.CommitOrRollbackTransaction", null);
        }
        catch (InterruptedException e) {
            log.error((Object)e.getMessage());
        }
    }

    protected void autoCommit(String txId) {
        try {
            this.notify(txId, null, "Repository.CommitOrRollbackTransaction", null);
        }
        catch (InterruptedException e) {
            log.error((Object)e.getMessage());
        }
    }

    private void stopThread(String txId) {
        TransactionalConversation txConv = this.getTxConv(txId);
        if (txConv != null) {
            txConv.getExecutor().shutdown();
            this.txPool.remove(txId);
            TransactionsSupervisor.removeConversation(txId);
        }
    }

    private TransactionalConversation getTxConv(String txId) {
        return (TransactionalConversation)this.txPool.get(txId);
    }

    public String getTxcId(long txc) {
        return TXC_ID_PREFIX + String.valueOf(txc);
    }
}

