/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation.transaction;

import fr.toutatice.ecm.platform.automation.transaction.TransactionalConversationManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransactionsSupervisor
implements Callable<Object> {
    private static Map<String, Long> currentConversations = new ConcurrentHashMap<String, Long>();
    TransactionalConversationManager txManager;
    private static long MAX_ELAPSED_TIME = 60000L;
    private static final Log log = LogFactory.getLog(TransactionsSupervisor.class);

    public TransactionsSupervisor(TransactionalConversationManager txManager) {
        this.txManager = txManager;
    }

    public static void addConversation(String txId) {
        currentConversations.put(txId, System.currentTimeMillis());
    }

    public static void removeConversation(String txId) {
        currentConversations.remove(txId);
    }

    @Override
    public Object call() throws Exception {
        block0: while (true) {
            Thread.sleep(1000L);
            long current = System.currentTimeMillis();
            HashMap<String, Long> tempConversations = new HashMap<String, Long>();
            for (Map.Entry<String, Long> entry : currentConversations.entrySet()) {
                tempConversations.put(entry.getKey(), entry.getValue());
            }
            Iterator<Map.Entry<String, Long>> iterator = tempConversations.entrySet().iterator();
            while (true) {
                Map.Entry<String, Long> entry;
                if (!iterator.hasNext()) continue block0;
                entry = iterator.next();
                long elapsedTime = current - entry.getValue();
                if (elapsedTime <= MAX_ELAPSED_TIME) continue;
                log.warn((Object)("rollback pending transaction " + tempConversations.size()));
                this.txManager.forceRollback(entry.getKey());
            }
            break;
        }
    }
}

