/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation.trash;

import java.security.Principal;
import java.util.List;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.trash.TrashInfo;
import org.nuxeo.ecm.core.trash.TrashService;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractTrashOperation {
    protected TrashInfo getRecursiveTrashInfo(TrashService trashService, CoreSession session, List<DocumentModel> docs) {
        TrashInfo trashInfo = null;
        if (docs != null) {
            trashInfo = trashService.getTrashInfo(docs, session.getPrincipal(), false, false);
            if (trashInfo.forbidden > 0) {
                return trashInfo;
            }
            for (DocumentModel doc : docs) {
                DocumentModelList children = session.getChildren(doc.getRef(), null, "Remove");
                trashInfo = this.getRecursiveTrashInfo(trashService, session, (List<DocumentModel>)children);
            }
        }
        return trashInfo;
    }

    public DocumentModelList execute(CoreSession session, DocumentModel parent) throws Exception {
        if (parent == null) {
            throw new Exception("\"parent\" parameter is undefined.");
        }
        String parentId = parent.getId();
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM Document ");
        query.append("WHERE ecm:ancestorId = '").append(parentId).append("' ");
        query.append("AND ecm:currentLifeCycleState = 'deleted' ");
        query.append("AND ecm:isProxy = 0 ");
        query.append("AND ecm:isVersion = 0 ");
        DocumentModelList documents = session.query(query.toString());
        return this.execute(session, documents);
    }

    public DocumentModelList execute(CoreSession session, DocumentModelList documents) throws Exception {
        TrashService trashService = (TrashService)Framework.getService(TrashService.class);
        Principal principal = session.getPrincipal();
        TrashInfo info = trashService.getTrashInfo((List)documents, principal, false, false);
        DocumentModelListImpl rejected = new DocumentModelListImpl(info.forbidden);
        if (info.forbidden > 0) {
            for (DocumentModel document : documents) {
                if (info.docs.contains(document)) continue;
                rejected.add((Object)document);
            }
        }
        this.invoke(trashService, info);
        return rejected;
    }

    public abstract void invoke(TrashService var1, TrashInfo var2) throws Exception;
}

