/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.resource.Representation;
import org.restlet.resource.StringRepresentation;
import org.restlet.util.WrapperList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceList
extends WrapperList<Reference> {
    private Reference identifier;

    public ReferenceList() {
    }

    public ReferenceList(int initialCapacity) {
        super(new ArrayList(initialCapacity));
    }

    public ReferenceList(List<Reference> delegate) {
        super(delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferenceList(Representation uriList) throws IOException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(uriList.getStream()));
            String line = br.readLine();
            if (line != null && line.startsWith("#")) {
                this.setIdentifier(new Reference(line.substring(1).trim()));
                line = br.readLine();
            }
            while (line != null) {
                if (!line.startsWith("#")) {
                    this.add(new Reference(line.trim()));
                }
                line = br.readLine();
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    @Override
    public boolean add(String uri) {
        return this.add(new Reference(uri));
    }

    public Reference getIdentifier() {
        return this.identifier;
    }

    public Representation getTextRepresentation() {
        StringBuilder sb = new StringBuilder();
        if (this.getIdentifier() != null) {
            sb.append("# ").append(this.getIdentifier().toString()).append("\r\n");
        }
        for (Reference ref : this) {
            sb.append(ref.toString()).append("\r\n");
        }
        return new StringRepresentation((CharSequence)sb.toString(), MediaType.TEXT_URI_LIST);
    }

    public Representation getWebRepresentation() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body>\n");
        if (this.getIdentifier() != null) {
            sb.append("<h2>Listing of \"" + this.getIdentifier().getPath() + "\"</h2>\n");
            Reference parentRef = this.getIdentifier().getParentRef();
            if (!parentRef.equals(this.getIdentifier())) {
                sb.append("<a href=\"" + parentRef + "\">..</a><br/>\n");
            }
        } else {
            sb.append("<h2>List of references</h2>\n");
        }
        for (Reference ref : this) {
            sb.append("<a href=\"" + ref.toString() + "\">" + ref.getRelativeRef(this.getIdentifier()) + "</a><br/>\n");
        }
        sb.append("</body></html>\n");
        return new StringRepresentation((CharSequence)sb.toString(), MediaType.TEXT_HTML);
    }

    public void setIdentifier(Reference identifier) {
        this.identifier = identifier;
    }

    public void setIdentifier(String identifier) {
        this.setIdentifier(new Reference(identifier));
    }

    public ReferenceList subList(int fromIndex, int toIndex) {
        return new ReferenceList(this.getDelegate().subList(fromIndex, toIndex));
    }
}

