/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.collab.tools.quickaccess;

import fr.toutatice.ecm.platform.collab.tools.quickaccess.DocumentQuickAccessInfosProvider;
import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;

public class DocumentQuickAccessInfosProviderImpl
implements DocumentQuickAccessInfosProvider {
    private static final String QUICK_ACCESS_STATUS = "quickAccess_status";
    private static final String FACET_SETS = "Sets";
    private static final String LIST_WEBID_PROPERTY = "webids";
    private static final String NAME_PROPERTY = "name";
    private static final String SCHEMA_TOUTATICE = "toutatice";
    private static final String WEBID_PROPERTY = "ttc:webid";
    private static final String SETS_PROPERTY = "sets:sets";
    private static final String SET_PROPERTY = "set";
    private static final String SETS_SCHEMA = "sets";
    private static final String QUICK_ACCESS_PROPERTY = "quickAccess";

    @Override
    public void addToQuickAccess(CoreSession coreSession, DocumentModel currentDocument) {
        if (this.getStatus(coreSession, currentDocument) == QuickAccessStatus.can_add_to_quickaccess) {
            DocumentModel workspace = ToutaticeDocumentHelper.getWorkspace((CoreSession)coreSession, (DocumentModel)currentDocument, (boolean)true);
            Map map = workspace.getProperties(SETS_SCHEMA);
            ArrayList listSets = (ArrayList)map.get(SETS_PROPERTY);
            boolean quickAccessSetExist = false;
            String webid = (String)currentDocument.getProperty(SCHEMA_TOUTATICE, WEBID_PROPERTY);
            int index = 0;
            for (Map set : listSets) {
                if (QUICK_ACCESS_PROPERTY.equals(set.get(NAME_PROPERTY))) {
                    quickAccessSetExist = true;
                    String[] listQuickAccess = (String[])set.get(LIST_WEBID_PROPERTY);
                    if (listQuickAccess != null) {
                        String[] newListQuickAccess = new String[listQuickAccess.length + 1];
                        for (int i = 0; i < listQuickAccess.length; ++i) {
                            newListQuickAccess[i] = listQuickAccess[i];
                        }
                        newListQuickAccess[listQuickAccess.length] = webid;
                        set.put(LIST_WEBID_PROPERTY, newListQuickAccess);
                        workspace.setPropertyValue("sets:sets/[" + index + "]", (Serializable)((Object)set));
                        ToutaticeDocumentHelper.saveDocumentSilently((CoreSession)coreSession, (DocumentModel)workspace, (boolean)true);
                    }
                }
                ++index;
            }
            if (!quickAccessSetExist) {
                int quickAccessSetIndex = 0;
                if (listSets != null) {
                    quickAccessSetIndex = listSets.size();
                }
                HashMap<String, Object> mapSet = new HashMap<String, Object>();
                String[] webids = new String[]{webid};
                mapSet.put(NAME_PROPERTY, QUICK_ACCESS_PROPERTY);
                mapSet.put(LIST_WEBID_PROPERTY, webids);
                listSets.add(mapSet);
                HashMap<String, ArrayList> mapToSave = new HashMap<String, ArrayList>();
                mapToSave.put(SETS_PROPERTY, listSets);
                workspace.setProperties(SETS_SCHEMA, mapToSave);
                ToutaticeDocumentHelper.saveDocumentSilently((CoreSession)coreSession, (DocumentModel)workspace, (boolean)true);
            }
        } else {
            throw new ClientException("User can not add this document to quickaccess set");
        }
    }

    @Override
    public void removeFromQuickAccess(CoreSession coreSession, DocumentModel currentDocument) throws ClientException, ClassNotFoundException {
        if (this.getStatus(coreSession, currentDocument) == QuickAccessStatus.can_remove_from_quickaccess) {
            DocumentModel workspace = ToutaticeDocumentHelper.getWorkspace((CoreSession)coreSession, (DocumentModel)currentDocument, (boolean)true);
            Map map = workspace.getProperties(SETS_SCHEMA);
            ArrayList listSets = (ArrayList)map.get(SETS_PROPERTY);
            String webid = (String)currentDocument.getProperty(SCHEMA_TOUTATICE, WEBID_PROPERTY);
            int index = 0;
            for (HashMap set : listSets) {
                String[] listQuickAccess;
                if (QUICK_ACCESS_PROPERTY.equals(set.get(NAME_PROPERTY)) && (listQuickAccess = (String[])set.get(LIST_WEBID_PROPERTY)) != null && listQuickAccess.length > 0) {
                    String[] newListQuickAccess = new String[listQuickAccess.length - 1];
                    int j = 0;
                    for (int i = 0; i < listQuickAccess.length; ++i) {
                        if (StringUtils.equals((String)webid, (String)listQuickAccess[i])) continue;
                        newListQuickAccess[j] = listQuickAccess[i];
                        ++j;
                    }
                    set.put(LIST_WEBID_PROPERTY, newListQuickAccess);
                    workspace.setPropertyValue("sets:sets/set[" + index + "]", (Serializable)set);
                    ToutaticeDocumentHelper.saveDocumentSilently((CoreSession)coreSession, (DocumentModel)workspace, (boolean)true);
                }
                ++index;
            }
        } else {
            throw new ClientException("User can not remove this document from quickaccess set");
        }
    }

    public Map<String, Object> fetchInfos(CoreSession coreSession, DocumentModel currentDocument) throws ClientException {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put(QUICK_ACCESS_STATUS, this.getStatus(coreSession, currentDocument).toString());
        return infos;
    }

    private QuickAccessStatus getStatus(CoreSession coreSession, DocumentModel currentDocument) throws ClientException {
        Set facetSet;
        boolean hasSetsFacet;
        DocumentModel workspace;
        QuickAccessStatus status = QuickAccessStatus.cannot_add_to_quickaccess;
        String webid = (String)currentDocument.getProperty(SCHEMA_TOUTATICE, WEBID_PROPERTY);
        if (StringUtils.isNotEmpty((String)webid) && (workspace = ToutaticeDocumentHelper.getWorkspace((CoreSession)coreSession, (DocumentModel)currentDocument, (boolean)true)) != null && (hasSetsFacet = (facetSet = workspace.getFacets()).contains(FACET_SETS))) {
            status = QuickAccessStatus.can_add_to_quickaccess;
            Map map = workspace.getProperties(SETS_SCHEMA);
            ArrayList listSets = (ArrayList)map.get(SETS_PROPERTY);
            block0: for (HashMap set : listSets) {
                if (!QUICK_ACCESS_PROPERTY.equals(set.get(NAME_PROPERTY))) continue;
                String[] listQuickAccess = (String[])set.get(LIST_WEBID_PROPERTY);
                for (int i = 0; i < listQuickAccess.length; ++i) {
                    if (!StringUtils.equals((String)webid, (String)listQuickAccess[i])) continue;
                    status = QuickAccessStatus.can_remove_from_quickaccess;
                    continue block0;
                }
            }
        }
        return status;
    }

    public static enum QuickAccessStatus {
        can_add_to_quickaccess,
        can_remove_from_quickaccess,
        cannot_add_to_quickaccess;

    }
}

