/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blockterms;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.PostingsConsumer;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.codecs.TermStats;
import org.apache.lucene.codecs.TermsConsumer;
import org.apache.lucene.codecs.blockterms.TermsIndexWriterBase;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;

public class BlockTermsWriter
extends FieldsConsumer {
    static final String CODEC_NAME = "BLOCK_TERMS_DICT";
    public static final int VERSION_START = 0;
    public static final int VERSION_APPEND_ONLY = 1;
    public static final int VERSION_META_ARRAY = 2;
    public static final int VERSION_CURRENT = 2;
    static final String TERMS_EXTENSION = "tib";
    protected final IndexOutput out;
    final PostingsWriterBase postingsWriter;
    final FieldInfos fieldInfos;
    FieldInfo currentField;
    private final TermsIndexWriterBase termsIndexWriter;
    private final List<FieldMetaData> fields = new ArrayList<FieldMetaData>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BlockTermsWriter(TermsIndexWriterBase termsIndexWriter, SegmentWriteState state, PostingsWriterBase postingsWriter) throws IOException {
        String termsFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)TERMS_EXTENSION);
        this.termsIndexWriter = termsIndexWriter;
        this.out = state.directory.createOutput(termsFileName, state.context);
        boolean success = false;
        try {
            this.fieldInfos = state.fieldInfos;
            this.writeHeader(this.out);
            this.currentField = null;
            this.postingsWriter = postingsWriter;
            postingsWriter.init(this.out);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.out});
            throw throwable;
        }
    }

    private void writeHeader(IndexOutput out) throws IOException {
        CodecUtil.writeHeader((DataOutput)out, (String)CODEC_NAME, (int)2);
    }

    public TermsConsumer addField(FieldInfo field) throws IOException {
        assert (this.currentField == null || this.currentField.name.compareTo(field.name) < 0);
        this.currentField = field;
        TermsIndexWriterBase.FieldWriter fieldIndexWriter = this.termsIndexWriter.addField(field, this.out.getFilePointer());
        return new TermsWriter(fieldIndexWriter, field, this.postingsWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            long dirStart = this.out.getFilePointer();
            this.out.writeVInt(this.fields.size());
            for (FieldMetaData field : this.fields) {
                this.out.writeVInt(field.fieldInfo.number);
                this.out.writeVLong(field.numTerms);
                this.out.writeVLong(field.termsStartPointer);
                if (field.fieldInfo.getIndexOptions() != FieldInfo.IndexOptions.DOCS_ONLY) {
                    this.out.writeVLong(field.sumTotalTermFreq);
                }
                this.out.writeVLong(field.sumDocFreq);
                this.out.writeVInt(field.docCount);
                this.out.writeVInt(field.longsSize);
            }
            this.writeTrailer(dirStart);
        }
        catch (Throwable throwable) {
            IOUtils.close((Closeable[])new Closeable[]{this.out, this.postingsWriter, this.termsIndexWriter});
            throw throwable;
        }
        IOUtils.close((Closeable[])new Closeable[]{this.out, this.postingsWriter, this.termsIndexWriter});
    }

    private void writeTrailer(long dirStart) throws IOException {
        this.out.writeLong(dirStart);
    }

    class TermsWriter
    extends TermsConsumer {
        private final FieldInfo fieldInfo;
        private final PostingsWriterBase postingsWriter;
        private final long termsStartPointer;
        private long numTerms;
        private final TermsIndexWriterBase.FieldWriter fieldIndexWriter;
        long sumTotalTermFreq;
        long sumDocFreq;
        int docCount;
        int longsSize;
        private TermEntry[] pendingTerms;
        private int pendingCount;
        private final BytesRef lastPrevTerm = new BytesRef();
        private final RAMOutputStream bytesWriter = new RAMOutputStream();
        private final RAMOutputStream bufferWriter = new RAMOutputStream();

        TermsWriter(TermsIndexWriterBase.FieldWriter fieldIndexWriter, FieldInfo fieldInfo, PostingsWriterBase postingsWriter) {
            this.fieldInfo = fieldInfo;
            this.fieldIndexWriter = fieldIndexWriter;
            this.pendingTerms = new TermEntry[32];
            for (int i = 0; i < this.pendingTerms.length; ++i) {
                this.pendingTerms[i] = new TermEntry();
            }
            this.termsStartPointer = BlockTermsWriter.this.out.getFilePointer();
            this.postingsWriter = postingsWriter;
            this.longsSize = postingsWriter.setField(fieldInfo);
        }

        public Comparator<BytesRef> getComparator() {
            return BytesRef.getUTF8SortedAsUnicodeComparator();
        }

        public PostingsConsumer startTerm(BytesRef text) throws IOException {
            this.postingsWriter.startTerm();
            return this.postingsWriter;
        }

        public void finishTerm(BytesRef text, TermStats stats) throws IOException {
            assert (stats.docFreq > 0);
            boolean isIndexTerm = this.fieldIndexWriter.checkIndexTerm(text, stats);
            if (isIndexTerm) {
                if (this.pendingCount > 0) {
                    this.flushBlock();
                }
                this.fieldIndexWriter.add(text, stats, BlockTermsWriter.this.out.getFilePointer());
            }
            if (this.pendingTerms.length == this.pendingCount) {
                TermEntry[] newArray = new TermEntry[ArrayUtil.oversize((int)(this.pendingCount + 1), (int)RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
                System.arraycopy(this.pendingTerms, 0, newArray, 0, this.pendingCount);
                for (int i = this.pendingCount; i < newArray.length; ++i) {
                    newArray[i] = new TermEntry();
                }
                this.pendingTerms = newArray;
            }
            TermEntry te = this.pendingTerms[this.pendingCount];
            te.term.copyBytes(text);
            te.state = this.postingsWriter.newTermState();
            te.state.docFreq = stats.docFreq;
            te.state.totalTermFreq = stats.totalTermFreq;
            this.postingsWriter.finishTerm(te.state);
            ++this.pendingCount;
            ++this.numTerms;
        }

        public void finish(long sumTotalTermFreq, long sumDocFreq, int docCount) throws IOException {
            if (this.pendingCount > 0) {
                this.flushBlock();
            }
            BlockTermsWriter.this.out.writeVInt(0);
            this.sumTotalTermFreq = sumTotalTermFreq;
            this.sumDocFreq = sumDocFreq;
            this.docCount = docCount;
            this.fieldIndexWriter.finish(BlockTermsWriter.this.out.getFilePointer());
            if (this.numTerms > 0L) {
                BlockTermsWriter.this.fields.add(new FieldMetaData(this.fieldInfo, this.numTerms, this.termsStartPointer, sumTotalTermFreq, sumDocFreq, docCount, this.longsSize));
            }
        }

        private int sharedPrefix(BytesRef term1, BytesRef term2) {
            assert (term1.offset == 0);
            assert (term2.offset == 0);
            int pos1 = 0;
            int pos1End = pos1 + Math.min(term1.length, term2.length);
            int pos2 = 0;
            while (pos1 < pos1End) {
                if (term1.bytes[pos1] != term2.bytes[pos2]) {
                    return pos1;
                }
                ++pos1;
                ++pos2;
            }
            return pos1;
        }

        private void flushBlock() throws IOException {
            int termCount;
            int commonPrefix = this.sharedPrefix(this.lastPrevTerm, this.pendingTerms[0].term);
            for (termCount = 1; termCount < this.pendingCount; ++termCount) {
                commonPrefix = Math.min(commonPrefix, this.sharedPrefix(this.lastPrevTerm, this.pendingTerms[termCount].term));
            }
            BlockTermsWriter.this.out.writeVInt(this.pendingCount);
            BlockTermsWriter.this.out.writeVInt(commonPrefix);
            for (termCount = 0; termCount < this.pendingCount; ++termCount) {
                int suffix = this.pendingTerms[termCount].term.length - commonPrefix;
                this.bytesWriter.writeVInt(suffix);
                this.bytesWriter.writeBytes(this.pendingTerms[termCount].term.bytes, commonPrefix, suffix);
            }
            BlockTermsWriter.this.out.writeVInt((int)this.bytesWriter.getFilePointer());
            this.bytesWriter.writeTo((DataOutput)BlockTermsWriter.this.out);
            this.bytesWriter.reset();
            for (termCount = 0; termCount < this.pendingCount; ++termCount) {
                BlockTermState state = this.pendingTerms[termCount].state;
                assert (state != null);
                this.bytesWriter.writeVInt(state.docFreq);
                if (this.fieldInfo.getIndexOptions() == FieldInfo.IndexOptions.DOCS_ONLY) continue;
                this.bytesWriter.writeVLong(state.totalTermFreq - (long)state.docFreq);
            }
            BlockTermsWriter.this.out.writeVInt((int)this.bytesWriter.getFilePointer());
            this.bytesWriter.writeTo((DataOutput)BlockTermsWriter.this.out);
            this.bytesWriter.reset();
            long[] longs = new long[this.longsSize];
            boolean absolute = true;
            for (int termCount2 = 0; termCount2 < this.pendingCount; ++termCount2) {
                BlockTermState state = this.pendingTerms[termCount2].state;
                this.postingsWriter.encodeTerm(longs, (DataOutput)this.bufferWriter, this.fieldInfo, state, absolute);
                for (int i = 0; i < this.longsSize; ++i) {
                    this.bytesWriter.writeVLong(longs[i]);
                }
                this.bufferWriter.writeTo((DataOutput)this.bytesWriter);
                this.bufferWriter.reset();
                absolute = false;
            }
            BlockTermsWriter.this.out.writeVInt((int)this.bytesWriter.getFilePointer());
            this.bytesWriter.writeTo((DataOutput)BlockTermsWriter.this.out);
            this.bytesWriter.reset();
            this.lastPrevTerm.copyBytes(this.pendingTerms[this.pendingCount - 1].term);
            this.pendingCount = 0;
        }
    }

    private static class TermEntry {
        public final BytesRef term = new BytesRef();
        public BlockTermState state;

        private TermEntry() {
        }
    }

    private static class FieldMetaData {
        public final FieldInfo fieldInfo;
        public final long numTerms;
        public final long termsStartPointer;
        public final long sumTotalTermFreq;
        public final long sumDocFreq;
        public final int docCount;
        public final int longsSize;

        public FieldMetaData(FieldInfo fieldInfo, long numTerms, long termsStartPointer, long sumTotalTermFreq, long sumDocFreq, int docCount, int longsSize) {
            assert (numTerms > 0L);
            this.fieldInfo = fieldInfo;
            this.termsStartPointer = termsStartPointer;
            this.numTerms = numTerms;
            this.sumTotalTermFreq = sumTotalTermFreq;
            this.sumDocFreq = sumDocFreq;
            this.docCount = docCount;
            this.longsSize = longsSize;
        }
    }
}

