/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.aggregate;

import com.phloc.commons.aggregate.IAggregator;
import com.phloc.commons.aggregate.IAggregatorFactory;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.lang.ClassHelper;
import com.phloc.commons.lang.GenericReflection;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class AggregatorFactoryNewInstance<SRCTYPE, DSTTYPE>
implements IAggregatorFactory<SRCTYPE, DSTTYPE> {
    private final Class<? extends IAggregator<?, ?>> m_aClass;

    public <DATATYPE extends IAggregator<?, ?>> AggregatorFactoryNewInstance(@Nonnull Class<DATATYPE> clazz) {
        if (clazz == null) {
            throw new NullPointerException("class");
        }
        if (!ClassHelper.isInstancableClass(clazz)) {
            throw new IllegalArgumentException("Class " + clazz + " is not instancable!");
        }
        this.m_aClass = clazz;
    }

    @Override
    @Nullable
    public IAggregator<SRCTYPE, DSTTYPE> create() {
        return (IAggregator)GenericReflection.uncheckedCast(GenericReflection.newInstance(this.m_aClass));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AggregatorFactoryNewInstance)) {
            return false;
        }
        AggregatorFactoryNewInstance aggregatorFactoryNewInstance = (AggregatorFactoryNewInstance)object;
        return this.m_aClass.equals(aggregatorFactoryNewInstance.m_aClass);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aClass).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("class", this.m_aClass).toString();
    }
}

