/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.cache;

import com.phloc.commons.cache.AbstractNotifyingCache;
import com.phloc.commons.cache.LoggingLRUCache;
import com.phloc.commons.string.ToStringGenerator;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractNotifyingCacheWithMaxSize<KEYTYPE, VALUETYPE>
extends AbstractNotifyingCache<KEYTYPE, VALUETYPE> {
    private final int m_nMaxSize;

    public AbstractNotifyingCacheWithMaxSize(@Nonnull String string, @Nonnegative int n) {
        super(string);
        if (n < 0) {
            throw new IllegalArgumentException("MaxSize must be > 0!");
        }
        this.m_nMaxSize = n;
    }

    @Nonnegative
    public final int getMaxSize() {
        return this.m_nMaxSize;
    }

    @Override
    @Nonnull
    protected final Map<KEYTYPE, VALUETYPE> createCache() {
        return new LoggingLRUCache(this.getName(), this.m_nMaxSize);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("maxSize", this.m_nMaxSize).toString();
    }
}

