/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.codec;

import com.phloc.commons.codec.AbstractLZWDictionary;
import com.phloc.commons.codec.LZWNode;
import com.phloc.commons.io.streams.NonBlockingByteArrayOutputStream;
import javax.annotation.Nullable;

final class LZWEncodeDictionary
extends AbstractLZWDictionary {
    private final LZWNode m_aRoot = new LZWNode();
    private final NonBlockingByteArrayOutputStream m_aByteBuf = new NonBlockingByteArrayOutputStream();

    @Override
    public void reset() {
        super.reset();
        for (int i = 0; i <= 255; ++i) {
            this.m_aRoot.setNode((byte)i, new LZWNode(i));
        }
        this.m_aByteBuf.reset();
    }

    public int getCodeLength() {
        return this.m_nCodeBits;
    }

    public void visit(byte by) {
        this.m_aByteBuf.write(by);
        LZWNode lZWNode = this.m_aRoot;
        for (byte by2 : this.m_aByteBuf.toByteArray()) {
            LZWNode lZWNode2 = lZWNode;
            if ((lZWNode = lZWNode.getChildNode(by2)) != null) continue;
            lZWNode2.setNode(by2, new LZWNode(this.m_nFreeCode));
            this.addString(this.m_aByteBuf.toByteArray(), true);
            this.m_aByteBuf.reset();
            this.m_aByteBuf.write(by);
            break;
        }
    }

    @Nullable
    public LZWNode getNode(byte[] byArray) {
        return this.m_aRoot.getNode(byArray);
    }
}

