/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.iterate;

import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import java.util.Arrays;
import java.util.NoSuchElementException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.LongIterator;

public final class ArrayIteratorLong
implements LongIterator {
    private final long[] m_aArray;
    private int m_nIndex;

    public ArrayIteratorLong(long ... lArray) {
        this(lArray, 0, lArray.length);
    }

    public ArrayIteratorLong(@Nonnull long[] lArray, @Nonnegative int n, @Nonnegative int n2) {
        if (lArray == null) {
            throw new NullPointerException("array");
        }
        if (n < 0 || n2 < n) {
            throw new IllegalArgumentException("Begin (" + n + ") must be between 0 and < end (" + n2 + ")");
        }
        this.m_nIndex = 0;
        int n3 = n2 - n;
        this.m_aArray = ArrayHelper.getCopy(lArray, n, n3);
    }

    @Override
    public boolean hasNext() {
        return this.m_nIndex < this.m_aArray.length;
    }

    @Override
    public long next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.m_aArray[this.m_nIndex++];
    }

    @Override
    @Deprecated
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ArrayIteratorLong)) {
            return false;
        }
        ArrayIteratorLong arrayIteratorLong = (ArrayIteratorLong)object;
        return EqualsUtils.equals(this.m_aArray, arrayIteratorLong.m_aArray) && this.m_nIndex == arrayIteratorLong.m_nIndex;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aArray).append(this.m_nIndex).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("array", Arrays.toString(this.m_aArray)).append("index", this.m_nIndex).toString();
    }
}

