/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.compare;

import com.phloc.commons.compare.CollatorUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CompareUtils {
    public static final boolean DEFAULT_NULL_VALUES_COME_FIRST = true;
    private static final CompareUtils s_aInstance = new CompareUtils();

    private CompareUtils() {
    }

    public static int compare(double d, double d2) {
        return Double.compare(d, d2);
    }

    public static int compare(float f, float f2) {
        return Float.compare(f, f2);
    }

    public static <DATATYPE extends Comparable<? super DATATYPE>> int nullSafeCompare(@Nullable DATATYPE DATATYPE, @Nullable DATATYPE DATATYPE2) {
        return CompareUtils.nullSafeCompare(DATATYPE, DATATYPE2, true);
    }

    public static <DATATYPE extends Comparable<? super DATATYPE>> int nullSafeCompare(@Nullable DATATYPE DATATYPE, @Nullable DATATYPE DATATYPE2, boolean bl) {
        return DATATYPE == DATATYPE2 ? 0 : (DATATYPE == null ? (bl ? -1 : 1) : (DATATYPE2 == null ? (bl ? 1 : -1) : DATATYPE.compareTo(DATATYPE2)));
    }

    public static <DATATYPE> int nullSafeCompare(@Nullable DATATYPE DATATYPE, @Nullable DATATYPE DATATYPE2, @Nonnull Comparator<DATATYPE> comparator) {
        return CompareUtils.nullSafeCompare(DATATYPE, DATATYPE2, comparator, true);
    }

    public static <DATATYPE> int nullSafeCompare(@Nullable DATATYPE DATATYPE, @Nullable DATATYPE DATATYPE2, @Nonnull Comparator<DATATYPE> comparator, boolean bl) {
        return DATATYPE == DATATYPE2 ? 0 : (DATATYPE == null ? (bl ? -1 : 1) : (DATATYPE2 == null ? (bl ? 1 : -1) : comparator.compare(DATATYPE, DATATYPE2)));
    }

    public static int nullSafeCompare(@Nullable String string, @Nullable String string2, @Nonnull Locale locale) {
        return CompareUtils.nullSafeCompare(string, string2, locale, true);
    }

    public static int nullSafeCompare(@Nullable String string, @Nullable String string2, @Nonnull Locale locale, boolean bl) {
        return CompareUtils.nullSafeCompare(string, string2, CollatorUtils.getCollatorSpaceBeforeDot(locale), bl);
    }

    @SuppressFBWarnings(value={"ES_COMPARING_PARAMETER_STRING_WITH_EQ"})
    public static int nullSafeCompare(@Nullable String string, @Nullable String string2, @Nonnull Collator collator) {
        return CompareUtils.nullSafeCompare(string, string2, collator, true);
    }

    @SuppressFBWarnings(value={"ES_COMPARING_PARAMETER_STRING_WITH_EQ"})
    public static int nullSafeCompare(@Nullable String string, @Nullable String string2, @Nonnull Collator collator, boolean bl) {
        return string == string2 ? 0 : (string == null ? (bl ? -1 : 1) : (string2 == null ? (bl ? 1 : -1) : collator.compare(string, string2)));
    }
}

