/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.concurrent;

import com.phloc.commons.lang.TimeValue;
import com.phloc.commons.state.ESuccess;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ThreadUtils {
    private ThreadUtils() {
    }

    @Nonnull
    public static ESuccess sleepMinutes(@Nonnegative long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative minutes: " + l);
        }
        return ThreadUtils.sleep(l * 60000L);
    }

    @Nonnull
    public static ESuccess sleepSeconds(@Nonnegative long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative seconds: " + l);
        }
        return ThreadUtils.sleep(l * 1000L);
    }

    @Nonnull
    public static ESuccess sleep(@Nonnull TimeValue timeValue) {
        if (timeValue == null) {
            throw new NullPointerException("timeValue");
        }
        return ThreadUtils.sleep(timeValue.getAsMillis());
    }

    @Nonnull
    public static ESuccess sleep(@Nonnegative long l, @Nonnull TimeUnit timeUnit) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative duration: " + l);
        }
        if (timeUnit == null) {
            throw new NullPointerException("timeUnit");
        }
        return ThreadUtils.sleep(timeUnit.toMillis(l));
    }

    @Nonnull
    public static ESuccess sleep(@Nonnegative long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative milliseconds: " + l);
        }
        try {
            Thread.sleep(l);
            return ESuccess.SUCCESS;
        }
        catch (InterruptedException interruptedException) {
            return ESuccess.FAILURE;
        }
    }
}

