/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.format.impl;

import com.phloc.commons.format.IFormatter;
import com.phloc.commons.format.impl.AbstractStringFormatter;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;

public final class MinLengthAddLeadingFormatter
extends AbstractStringFormatter {
    private final int m_nMinLength;
    private final char m_cFill;

    public MinLengthAddLeadingFormatter(@Nonnegative int n, char c) {
        this(n, c, null);
    }

    public MinLengthAddLeadingFormatter(@Nonnegative int n, char c, @Nullable IFormatter iFormatter) {
        super(iFormatter);
        if (n < 1) {
            throw new IllegalArgumentException("Passed min length is too small: " + n);
        }
        this.m_nMinLength = n;
        this.m_cFill = c;
    }

    @Override
    protected String getFormattedValueAsString(@Nullable Object object) {
        String string = this.getValueAsString(object);
        if (string.length() >= this.m_nMinLength) {
            return string;
        }
        return StringHelper.getRepeated(this.m_cFill, this.m_nMinLength - string.length()) + string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MinLengthAddLeadingFormatter)) {
            return false;
        }
        MinLengthAddLeadingFormatter minLengthAddLeadingFormatter = (MinLengthAddLeadingFormatter)object;
        return this.m_nMinLength == minLengthAddLeadingFormatter.m_nMinLength && this.m_cFill == minLengthAddLeadingFormatter.m_cFill;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_nMinLength).append(this.m_cFill).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("minLength", this.m_nMinLength).append("fill", this.m_cFill).toString();
    }
}

