/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.file;

import com.phloc.commons.CGlobal;
import com.phloc.commons.SystemProperties;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.io.EAppend;
import com.phloc.commons.io.file.FileIOError;
import com.phloc.commons.io.file.FileOperations;
import com.phloc.commons.io.file.FilenameHelper;
import com.phloc.commons.io.misc.SizeHelper;
import com.phloc.commons.io.streams.CountingFileInputStream;
import com.phloc.commons.io.streams.CountingFileOutputStream;
import com.phloc.commons.state.EChange;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class FileUtils {
    private static final Logger s_aLogger = LoggerFactory.getLogger(FileUtils.class);
    private static final FileUtils s_aInstance = new FileUtils();

    private FileUtils() {
    }

    public static boolean existsFile(@Nonnull File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        return file.isFile();
    }

    public static boolean existsDir(@Nonnull File file) {
        if (file == null) {
            throw new NullPointerException("directory");
        }
        return file.isDirectory();
    }

    public static boolean canRead(@Nonnull File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        return file.canRead();
    }

    public static boolean canWrite(@Nonnull File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        return file.canWrite();
    }

    public static boolean canExecute(@Nonnull File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        return file.canExecute();
    }

    public static boolean canReadAndWriteFile(@Nonnull File file) {
        File file2;
        if (file == null) {
            throw new NullPointerException("file");
        }
        return !(FileUtils.existsFile(file) ? !FileUtils.canRead(file) || !FileUtils.canWrite(file) : (file2 = file.getParentFile()) != null && file2.isDirectory() && (!FileUtils.canRead(file2) || !FileUtils.canWrite(file2)));
    }

    @Nonnull
    public static EChange ensureParentDirectoryIsPresent(@Nonnull File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        File file2 = file.getParentFile();
        if (file2 == null || file2.exists()) {
            if (file2 != null && !file2.isDirectory()) {
                s_aLogger.warn("Parent object specified is not a directory: '" + file2 + "'");
            }
            return EChange.UNCHANGED;
        }
        FileIOError fileIOError = FileOperations.createDirRecursive(file2);
        if (fileIOError.isFailure()) {
            throw new IllegalStateException("Failed to create parent of " + file.getAbsolutePath() + ": " + fileIOError);
        }
        if (!file2.exists()) {
            throw new IllegalStateException("Parent of " + file.getAbsolutePath() + " is still not existing!");
        }
        return EChange.CHANGED;
    }

    @Nullable
    public static File getCanonicalFile(@Nullable File file) throws IOException {
        return file == null ? null : file.getCanonicalFile();
    }

    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    public static boolean isParentDirectory(@Nonnull File file, @Nonnull File file2) {
        if (file == null) {
            throw new NullPointerException("search directory");
        }
        if (file2 == null) {
            throw new NullPointerException("start directory");
        }
        File file3 = file.getAbsoluteFile();
        File file4 = file2.getAbsoluteFile();
        try {
            file3 = FileUtils.getCanonicalFile(file3);
            file4 = FileUtils.getCanonicalFile(file4);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!file3.isDirectory()) {
            return false;
        }
        for (File file5 = file4; file5 != null; file5 = file5.getParentFile()) {
            if (!file5.equals(file3)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static FileInputStream getInputStream(@Nonnull String string) {
        return FileUtils.getInputStream(new File(string));
    }

    @Nullable
    public static FileInputStream getInputStream(@Nonnull File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        try {
            return new CountingFileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    @Nullable
    public static FileOutputStream getOutputStream(@Nonnull String string) {
        return FileUtils.getOutputStream(string, EAppend.DEFAULT);
    }

    @Nullable
    public static FileOutputStream getOutputStream(@Nonnull String string, @Nonnull EAppend eAppend) {
        return FileUtils.getOutputStream(new File(string), eAppend);
    }

    @Nullable
    public static FileOutputStream getOutputStream(@Nonnull File file) {
        return FileUtils.getOutputStream(file, EAppend.DEFAULT);
    }

    @Nullable
    public static FileOutputStream getOutputStream(@Nonnull File file, @Nonnull EAppend eAppend) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (eAppend == null) {
            throw new NullPointerException("append");
        }
        try {
            FileUtils.ensureParentDirectoryIsPresent(file);
        }
        catch (IllegalStateException illegalStateException) {
            s_aLogger.warn("Failed to create parent directory of '" + file + "'", (Throwable)illegalStateException);
            return null;
        }
        File file2 = file.getParentFile();
        if (file2 != null && !FileUtils.canWrite(file2)) {
            s_aLogger.warn("Parent directory '" + file2 + "' of '" + file + "' is not writable for current user '" + SystemProperties.getUserName() + "'");
            return null;
        }
        try {
            return new CountingFileOutputStream(file, eAppend);
        }
        catch (FileNotFoundException fileNotFoundException) {
            s_aLogger.warn("Failed to create output stream for '" + file + "'; append: " + eAppend + ": " + fileNotFoundException.getClass().getName() + " - " + fileNotFoundException.getMessage());
            return null;
        }
    }

    public static boolean isFileNewer(@Nonnull File file, @Nonnull File file2) {
        if (file == null) {
            throw new NullPointerException("firstFile");
        }
        if (file2 == null) {
            throw new NullPointerException("secondFile");
        }
        if (file.equals(file2)) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        if (!file2.exists()) {
            return true;
        }
        return file.lastModified() > file2.lastModified();
    }

    @Nonnull
    public static String getFileSizeDisplay(@Nullable File file) {
        return FileUtils.getFileSizeDisplay(file, 0);
    }

    @Nonnull
    public static String getFileSizeDisplay(@Nullable File file, @Nonnegative int n) {
        if (file != null && file.exists()) {
            return FileUtils.getFileSizeDisplay(file.length(), n);
        }
        return "";
    }

    @Nonnull
    public static String getFileSizeDisplay(long l) {
        return FileUtils.getFileSizeDisplay(l, 0);
    }

    @Nonnull
    public static String getFileSizeDisplay(@Nonnegative long l, @Nonnegative int n) {
        if (l < 0L) {
            throw new IllegalArgumentException("File size may not be negative!");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Decimals may not be negative!");
        }
        return SizeHelper.getSizeHelperOfLocale(CGlobal.LOCALE_FIXED_NUMBER_FORMAT).getAsMatching(l, n);
    }

    @Nullable
    public static File getSecureFile(@Nullable File file) {
        if (file == null) {
            return null;
        }
        String string = null;
        for (File file2 = new File(FilenameHelper.getCleanPath(file)); file2 != null; file2 = file2.getParentFile()) {
            String string2 = file2.getParent() == null ? file2.getPath() : FilenameHelper.getAsSecureValidFilename(file2.getName());
            string = string == null ? string2 : string2 + "/" + string;
        }
        return new File(string);
    }

    @Nonnegative
    public static int getDirectoryObjectCount(@Nonnull File file) {
        if (file == null) {
            throw new NullPointerException("directory");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Passed object is not a directory: " + file);
        }
        int n = 0;
        for (File file2 : FileUtils.getDirectoryContent(file)) {
            if (FilenameHelper.isSystemInternalDirectory(file2.getName())) continue;
            ++n;
        }
        return n;
    }

    public static boolean safeEquals(@Nullable File file, @Nullable File file2) {
        if (file == file2) {
            return true;
        }
        if (file == null || file2 == null) {
            return false;
        }
        return FilenameHelper.getCleanPath(file.getAbsoluteFile()).equals(FilenameHelper.getCleanPath(file2.getAbsoluteFile()));
    }

    @Nonnull
    @ReturnsMutableCopy
    private static List<File> _getDirectoryContent(@Nonnull File file, @Nullable File[] fileArray) {
        if (fileArray == null) {
            if (!file.isDirectory()) {
                s_aLogger.warn("Cannot list non-directory: " + file.getAbsolutePath());
            } else if (!FileUtils.canExecute(file)) {
                s_aLogger.warn("Existing directory is missing the listing permission: " + file.getAbsolutePath());
            } else if (!FileUtils.canRead(file)) {
                s_aLogger.warn("Cannot list directory because of no read-rights: " + file.getAbsolutePath());
            } else {
                s_aLogger.warn("Directory listing failed because of IO error: " + file.getAbsolutePath());
            }
        } else if (!FileUtils.canExecute(file)) {
            s_aLogger.warn("Directory is missing the listing permission: " + file.getAbsolutePath());
        }
        return ContainerHelper.newList(fileArray);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<File> getDirectoryContent(@Nonnull File file) {
        if (file == null) {
            throw new NullPointerException("directory");
        }
        return FileUtils._getDirectoryContent(file, file.listFiles());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<File> getDirectoryContent(@Nonnull File file, @Nonnull FilenameFilter filenameFilter) {
        if (file == null) {
            throw new NullPointerException("directory");
        }
        if (filenameFilter == null) {
            throw new NullPointerException("filenameFilter");
        }
        return FileUtils._getDirectoryContent(file, file.listFiles(filenameFilter));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<File> getDirectoryContent(@Nonnull File file, @Nonnull FileFilter fileFilter) {
        if (file == null) {
            throw new NullPointerException("directory");
        }
        if (fileFilter == null) {
            throw new NullPointerException("fileFilter");
        }
        return FileUtils._getDirectoryContent(file, file.listFiles(fileFilter));
    }
}

