/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.file.filter;

import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.filter.FilterChainAND;
import com.phloc.commons.filter.FilterChainOR;
import com.phloc.commons.filter.IFilter;
import com.phloc.commons.io.file.filter.FileFilterFromFilenameFilter;
import com.phloc.commons.string.ToStringGenerator;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class FileFilterToIFilterAdapter
implements IFilter<File> {
    private final FileFilter m_aFileFilter;

    public FileFilterToIFilterAdapter(@Nonnull FilenameFilter filenameFilter) {
        this(new FileFilterFromFilenameFilter(filenameFilter));
    }

    public FileFilterToIFilterAdapter(@Nonnull FileFilter fileFilter) {
        if (fileFilter == null) {
            throw new NullPointerException("fileFilter");
        }
        this.m_aFileFilter = fileFilter;
    }

    @Override
    public boolean matchesFilter(@Nullable File file) {
        return this.m_aFileFilter.accept(file);
    }

    public String toString() {
        return new ToStringGenerator(this).append("fileFilter", this.m_aFileFilter).toString();
    }

    @Nonnull
    public static IFilter<File> getANDChained(FileFilter ... fileFilterArray) {
        if (ArrayHelper.isEmpty(fileFilterArray)) {
            throw new IllegalArgumentException("fileFilters");
        }
        ArrayList<FileFilterToIFilterAdapter> arrayList = new ArrayList<FileFilterToIFilterAdapter>();
        for (FileFilter fileFilter : fileFilterArray) {
            arrayList.add(new FileFilterToIFilterAdapter(fileFilter));
        }
        return new FilterChainAND<File>(arrayList);
    }

    @Nonnull
    public static IFilter<File> getANDChained(FilenameFilter ... filenameFilterArray) {
        if (ArrayHelper.isEmpty(filenameFilterArray)) {
            throw new IllegalArgumentException("filenameFilters");
        }
        ArrayList<FileFilterToIFilterAdapter> arrayList = new ArrayList<FileFilterToIFilterAdapter>();
        for (FilenameFilter filenameFilter : filenameFilterArray) {
            arrayList.add(new FileFilterToIFilterAdapter(filenameFilter));
        }
        return new FilterChainAND<File>(arrayList);
    }

    @Nonnull
    public static IFilter<File> getORChained(FileFilter ... fileFilterArray) {
        if (ArrayHelper.isEmpty(fileFilterArray)) {
            throw new IllegalArgumentException("fileFilters");
        }
        ArrayList<FileFilterToIFilterAdapter> arrayList = new ArrayList<FileFilterToIFilterAdapter>();
        for (FileFilter fileFilter : fileFilterArray) {
            arrayList.add(new FileFilterToIFilterAdapter(fileFilter));
        }
        return new FilterChainOR<File>(arrayList);
    }

    @Nonnull
    public static IFilter<File> getORChained(FilenameFilter ... filenameFilterArray) {
        if (ArrayHelper.isEmpty(filenameFilterArray)) {
            throw new IllegalArgumentException("fileFilters");
        }
        ArrayList<FileFilterToIFilterAdapter> arrayList = new ArrayList<FileFilterToIFilterAdapter>();
        for (FilenameFilter filenameFilter : filenameFilterArray) {
            arrayList.add(new FileFilterToIFilterAdapter(filenameFilter));
        }
        return new FilterChainOR<File>(arrayList);
    }
}

