/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.jaxb;

import com.phloc.commons.GlobalDebug;
import com.phloc.commons.cache.AbstractNotifyingCache;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class JAXBContextCache
extends AbstractNotifyingCache<Package, JAXBContext> {
    private static final JAXBContextCache s_aInstance = new JAXBContextCache();
    private static final Logger s_aLogger = LoggerFactory.getLogger(JAXBContextCache.class);

    private JAXBContextCache() {
        super(JAXBContextCache.class.getName());
    }

    @Nonnull
    public static JAXBContextCache getInstance() {
        return s_aInstance;
    }

    @Override
    @Nullable
    public JAXBContext getValueToCache(@Nullable Package package_) {
        if (package_ == null) {
            return null;
        }
        if (GlobalDebug.isDebugMode()) {
            s_aLogger.info("Creating JAXB context for package " + package_.getName());
        }
        try {
            if (package_.getAnnotation(XmlSchema.class) == null) {
                s_aLogger.warn("The package " + package_.getName() + " does not seem to be JAXB generated!");
            }
            return JAXBContext.newInstance((String)package_.getName());
        }
        catch (JAXBException jAXBException) {
            String string = "Failed to create JAXB context for package " + package_.getName();
            s_aLogger.error(string);
            throw new IllegalArgumentException(string, jAXBException);
        }
    }

    @Override
    @Nullable
    public JAXBContext getFromCache(@Nonnull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("class");
        }
        Package package_ = clazz.getPackage();
        if (package_.getAnnotation(XmlSchema.class) == null) {
            if (GlobalDebug.isDebugMode()) {
                s_aLogger.info("Creating JAXB context for class " + clazz.getName());
            }
            try {
                return JAXBContext.newInstance((Class[])new Class[]{clazz});
            }
            catch (JAXBException jAXBException) {
                String string = "Failed to create JAXB context for class " + clazz.getName();
                s_aLogger.error(string);
                throw new IllegalArgumentException(string, jAXBException);
            }
        }
        return (JAXBContext)this.getFromCache(package_);
    }
}

