/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.lang;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.LRUCache;
import com.phloc.commons.collections.iterate.IIterableIterator;
import com.phloc.commons.collections.iterate.IterableIterator;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ClassHierarchyCache {
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    private static final Map<String, ClassList> s_aClassHierarchy = new LRUCache<String, ClassList>(1000);

    private ClassHierarchyCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearClassHierarchyCache() {
        s_aRWLock.writeLock().lock();
        try {
            s_aClassHierarchy.clear();
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    static ClassList getClassList(@Nonnull Class<?> clazz) {
        ClassList classList;
        if (clazz == null) {
            throw new NullPointerException("class");
        }
        String string = clazz.getName();
        s_aRWLock.readLock().lock();
        try {
            classList = s_aClassHierarchy.get(string);
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
        if (classList == null) {
            s_aRWLock.writeLock().lock();
            try {
                classList = s_aClassHierarchy.get(string);
                if (classList == null) {
                    classList = new ClassList(clazz);
                    s_aClassHierarchy.put(string, classList);
                }
            }
            finally {
                s_aRWLock.writeLock().unlock();
            }
        }
        return classList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Class<?>> getClassHierarchy(@Nonnull Class<?> clazz) {
        return ClassHierarchyCache.getClassList(clazz).getAsSet();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<Class<?>> getClassHierarchyList(@Nonnull Class<?> clazz) {
        return ClassHierarchyCache.getClassList(clazz).getAsList();
    }

    @Nonnull
    public static Iterable<WeakReference<Class<?>>> getClassHierarchyIterator(@Nonnull Class<?> clazz) {
        return ClassHierarchyCache.getClassList(clazz);
    }

    @Immutable
    private static final class ClassList
    implements Iterable<WeakReference<Class<?>>> {
        private final List<WeakReference<Class<?>>> m_aList = new ArrayList();

        public ClassList(@Nonnull Class<?> clazz) {
            if (clazz == null) {
                throw new NullPointerException("class");
            }
            LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
            ArrayList arrayList = new ArrayList();
            arrayList.add(clazz);
            while (!arrayList.isEmpty()) {
                Class clazz2 = (Class)arrayList.remove(0);
                linkedHashSet.add(clazz2);
                for (Class<?> clazz3 : clazz2.getInterfaces()) {
                    arrayList.add(0, clazz3);
                }
                if (clazz2.getSuperclass() == null) continue;
                arrayList.add(0, clazz2.getSuperclass());
            }
            for (Class clazz4 : linkedHashSet) {
                this.m_aList.add(new WeakReference<Class>(clazz4));
            }
        }

        @Nonnull
        @ReturnsMutableCopy
        public Set<Class<?>> getAsSet() {
            LinkedHashSet linkedHashSet = new LinkedHashSet(this.m_aList.size());
            for (WeakReference<Class<?>> weakReference : this.m_aList) {
                Class clazz = (Class)weakReference.get();
                if (clazz == null) continue;
                linkedHashSet.add(clazz);
            }
            return linkedHashSet;
        }

        @Nonnull
        @ReturnsMutableCopy
        public List<Class<?>> getAsList() {
            ArrayList arrayList = new ArrayList(this.m_aList.size());
            for (WeakReference<Class<?>> weakReference : this.m_aList) {
                Class clazz = (Class)weakReference.get();
                if (clazz == null) continue;
                arrayList.add(clazz);
            }
            return arrayList;
        }

        @Override
        @Nonnull
        public IIterableIterator<WeakReference<Class<?>>> iterator() {
            return IterableIterator.create(this.m_aList);
        }
    }
}

