/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.messagedigest;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.charset.CharsetManager;
import com.phloc.commons.messagedigest.IMessageDigestGenerator;
import com.phloc.commons.messagedigest.MessageDigestGeneratorHelper;
import com.phloc.commons.string.StringHelper;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;

public abstract class AbstractMessageDigestGenerator
implements IMessageDigestGenerator {
    @Override
    @Nonnull
    public final IMessageDigestGenerator update(@Nonnull String string, @Nonnull @Nonempty String string2) {
        if (string == null) {
            throw new NullPointerException("value");
        }
        if (StringHelper.hasNoText(string2)) {
            throw new IllegalArgumentException("charset");
        }
        return this.update(CharsetManager.getAsBytes(string, string2));
    }

    @Override
    @Nonnull
    public final IMessageDigestGenerator update(@Nonnull String string, @Nonnull Charset charset) {
        if (string == null) {
            throw new NullPointerException("value");
        }
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        return this.update(CharsetManager.getAsBytes(string, charset));
    }

    @Override
    @Nonnull
    public final IMessageDigestGenerator update(@Nonnull byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("byteArray");
        }
        return this.update(byArray, 0, byArray.length);
    }

    @Override
    public final long getDigestLong() {
        return MessageDigestGeneratorHelper.getLongFromDigest(this.getDigest());
    }

    @Override
    @Nonnull
    public final String getDigestHexString() {
        return MessageDigestGeneratorHelper.getHexValueFromDigest(this.getDigest());
    }
}

