/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.mutable;

import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.mutable.IMutableNumeric;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class MutableDouble
extends Number
implements IMutableNumeric<MutableDouble> {
    public static final double DEFAULT_VALUE = 0.0;
    private double m_dValue;

    public MutableDouble() {
        this(0.0);
    }

    public MutableDouble(@Nonnull Double d) {
        this((double)d);
    }

    public MutableDouble(double d) {
        this.m_dValue = d;
    }

    @Override
    public double doubleValue() {
        return this.m_dValue;
    }

    @Nonnull
    public Double getAsDouble() {
        return this.m_dValue;
    }

    @Override
    public float floatValue() {
        return (float)this.m_dValue;
    }

    @Override
    public int intValue() {
        return (int)this.m_dValue;
    }

    @Override
    public long longValue() {
        return (long)this.m_dValue;
    }

    public double inc() {
        return this.inc(1.0);
    }

    public double inc(double d) {
        this.m_dValue += d;
        return this.m_dValue;
    }

    public double dec() {
        return this.inc(-1.0);
    }

    public double dec(double d) {
        return this.inc(-d);
    }

    @Nonnull
    public EChange set(double d) {
        if (EqualsUtils.equals(d, this.m_dValue)) {
            return EChange.UNCHANGED;
        }
        this.m_dValue = d;
        return EChange.CHANGED;
    }

    @Override
    public boolean is0() {
        return EqualsUtils.equals(this.m_dValue, 0.0);
    }

    @Override
    public boolean isNot0() {
        return !this.is0();
    }

    @Override
    public boolean isSmaller0() {
        return Double.compare(this.m_dValue, 0.0) < 0;
    }

    @Override
    public boolean isSmallerOrEqual0() {
        return Double.compare(this.m_dValue, 0.0) <= 0;
    }

    @Override
    public boolean isGreater0() {
        return Double.compare(this.m_dValue, 0.0) > 0;
    }

    @Override
    public boolean isGreaterOrEqual0() {
        return Double.compare(this.m_dValue, 0.0) >= 0;
    }

    @Override
    public int compareTo(MutableDouble mutableDouble) {
        return Double.compare(this.m_dValue, mutableDouble.m_dValue);
    }

    @Override
    @Nonnull
    public MutableDouble getClone() {
        return new MutableDouble(this.m_dValue);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MutableDouble)) {
            return false;
        }
        MutableDouble mutableDouble = (MutableDouble)object;
        return EqualsUtils.equals(this.m_dValue, mutableDouble.m_dValue);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_dValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("value", this.m_dValue).toString();
    }
}

