/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.system;

import com.phloc.commons.SystemProperties;
import javax.annotation.Nonnull;

public enum EJVMVendor {
    SUN_CLIENT{

        @Override
        protected boolean determineIfItIsCurrentJVMVendor() {
            boolean bl = EJVMVendor.SUN_VENDOR_NAME.equals(SystemProperties.getJavaVmVendor());
            return bl && !EJVMVendor._isSunServerJVM();
        }
    }
    ,
    SUN_SERVER{

        @Override
        protected boolean determineIfItIsCurrentJVMVendor() {
            boolean bl = EJVMVendor.SUN_VENDOR_NAME.equals(SystemProperties.getJavaVmVendor());
            return bl && EJVMVendor._isSunServerJVM();
        }
    }
    ,
    UNKNOWN{

        @Override
        protected boolean determineIfItIsCurrentJVMVendor() {
            return false;
        }
    };

    private static final String SUN_VENDOR_NAME = "Sun Microsystems Inc.";
    private static final String SYSPROP_JAVA_VM_NAME = "java.vm.name";
    private static volatile EJVMVendor s_aInstance;
    private final boolean m_bIsIt = this.determineIfItIsCurrentJVMVendor();

    private static boolean _isSunServerJVM() {
        String string = SystemProperties.getPropertyValue(SYSPROP_JAVA_VM_NAME);
        if ("Java HotSpot(TM) Server VM".equals(string)) {
            return true;
        }
        return "Java HotSpot(TM) 64-Bit Server VM".equals(string);
    }

    protected abstract boolean determineIfItIsCurrentJVMVendor();

    public final boolean isJVMVendor() {
        return this.m_bIsIt;
    }

    public final boolean isSun() {
        return this == SUN_CLIENT || this == SUN_SERVER;
    }

    @Nonnull
    public static EJVMVendor getCurrentVendor() {
        EJVMVendor eJVMVendor = s_aInstance;
        if (eJVMVendor == null) {
            for (EJVMVendor eJVMVendor2 : EJVMVendor.values()) {
                if (!eJVMVendor2.isJVMVendor()) continue;
                eJVMVendor = eJVMVendor2;
                break;
            }
            if (eJVMVendor == null) {
                eJVMVendor = UNKNOWN;
            }
            s_aInstance = eJVMVendor;
        }
        return eJVMVendor;
    }

    static {
        s_aInstance = null;
    }
}

