/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.text.impl;

import com.phloc.commons.text.ITextProvider;
import com.phloc.commons.text.impl.TextFormatter;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractTextProvider
implements ITextProvider {
    protected AbstractTextProvider() {
    }

    @Nullable
    protected abstract String internalGetText(@Nonnull Locale var1);

    @Nullable
    protected abstract Locale internalGetLocaleToUseWithFallback(@Nonnull Locale var1);

    @Override
    @Nullable
    public final String getText(@Nonnull Locale locale) {
        if (locale == null) {
            throw new NullPointerException("locale");
        }
        return this.internalGetText(locale);
    }

    @Override
    @Nullable
    public final String getTextWithLocaleFallback(@Nonnull Locale locale) {
        if (locale == null) {
            throw new NullPointerException("locale");
        }
        Locale locale2 = this.internalGetLocaleToUseWithFallback(locale);
        return locale2 == null ? null : this.internalGetText(locale2);
    }

    @Override
    @Nullable
    public final String getTextWithArgs(@Nonnull Locale locale, Object ... objectArray) {
        String string = this.getText(locale);
        return TextFormatter.getFormattedText(string, objectArray);
    }

    @Override
    @Nullable
    public final String getTextWithLocaleFallbackAndArgs(@Nonnull Locale locale, Object ... objectArray) {
        String string = this.getTextWithLocaleFallback(locale);
        return TextFormatter.getFormattedText(string, objectArray);
    }
}

