/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.url;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.url.IURLProtocol;
import com.phloc.commons.url.URLProtocolRegistry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EURLProtocol implements IURLProtocol
{
    HTTP("http://"),
    HTTPS("https://"),
    FILE("file://"),
    FTP("ftp://"),
    CALLTO("callto:"),
    DATA("data:"),
    FTPS("ftps://"),
    GEO("geo:"),
    GOPHER("gopher://"),
    JAVASCRIPT("javascript:"),
    LDAP("ldap:"),
    MAILTO("mailto:"),
    MMS("mms:"),
    NEWS("news:"),
    NNTP("nntp:"),
    POP("pop://"),
    RSYNC("rsync:"),
    RTMP("rtmp://"),
    RTSP("rtsp://"),
    RTSPU("rtspu://"),
    SCP("scp://"),
    SFTP("sftp://"),
    SHTTP("shttp://"),
    SIP("sip:"),
    SIPS("sips:"),
    TEL("tel:"),
    TELNET("telnet://"),
    URN("urn:"),
    WS("ws://"),
    WSS("wss://");

    private final String m_sProtocol;

    private EURLProtocol(String string2) {
        this.m_sProtocol = string2;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getProtocol() {
        return this.m_sProtocol;
    }

    @Override
    public boolean isUsedInURL(@Nullable String string) {
        return string != null && string.startsWith(this.m_sProtocol, 0);
    }

    @Override
    @Nullable
    public String getWithProtocol(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return this.m_sProtocol + string;
    }

    @Override
    @Nullable
    public String getWithProtocolIfNone(@Nullable String string) {
        if (string == null || URLProtocolRegistry.hasKnownProtocol(string)) {
            return string;
        }
        return this.m_sProtocol + string;
    }

    @Override
    public boolean allowsForQueryParameters() {
        return this == HTTP || this == HTTPS || this == MAILTO || this == SHTTP;
    }
}

