/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.filter.IFilter;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.w3c.dom.Element;

@NotThreadSafe
public final class FilterElementWithTagName
implements IFilter<Element> {
    private final String m_sTagName;

    public FilterElementWithTagName(@Nonnull @Nonempty String string) {
        if (StringHelper.hasNoText(string)) {
            throw new IllegalArgumentException("tagName");
        }
        this.m_sTagName = string;
    }

    @Override
    public boolean matchesFilter(@Nonnull Element element) {
        return element.getNamespaceURI() == null && element.getTagName().equals(this.m_sTagName);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FilterElementWithTagName)) {
            return false;
        }
        FilterElementWithTagName filterElementWithTagName = (FilterElementWithTagName)object;
        return this.m_sTagName.equals(filterElementWithTagName.m_sTagName);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sTagName).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("tagName", this.m_sTagName).toString();
    }
}

