/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.sax;

import com.phloc.commons.io.IInputStreamProvider;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.resource.FileSystemResource;
import com.phloc.commons.io.resource.URLResource;
import com.phloc.commons.io.streams.NonBlockingByteArrayInputStream;
import com.phloc.commons.xml.sax.ReadableResourceSAXInputSource;
import com.phloc.commons.xml.sax.StringSAXInputSource;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.xml.sax.InputSource;

@Immutable
public final class InputSourceFactory {
    private InputSourceFactory() {
    }

    @Nonnull
    public static InputSource create(@Nonnull File file) {
        return InputSourceFactory.create(new FileSystemResource(file));
    }

    @Nonnull
    public static InputSource create(@Nonnull URL uRL) {
        return InputSourceFactory.create(new URLResource(uRL));
    }

    @Nonnull
    public static InputSource create(@Nonnull IInputStreamProvider iInputStreamProvider) {
        if (iInputStreamProvider instanceof IReadableResource) {
            return InputSourceFactory.create((IReadableResource)iInputStreamProvider);
        }
        return InputSourceFactory.create(iInputStreamProvider.getInputStream());
    }

    @Nonnull
    public static InputSource create(@Nonnull IReadableResource iReadableResource) {
        return new ReadableResourceSAXInputSource(iReadableResource);
    }

    @Nonnull
    public static InputSource create(@Nonnull String string) {
        return new StringSAXInputSource(string);
    }

    @Nonnull
    public static InputSource create(@Nonnull char[] cArray) {
        return InputSourceFactory.create(new String(cArray));
    }

    @Nonnull
    public static InputSource create(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        return InputSourceFactory.create(new String(cArray, n, n2));
    }

    @Nonnull
    public static InputSource create(@Nonnull byte[] byArray) {
        return InputSourceFactory.create(new NonBlockingByteArrayInputStream(byArray));
    }

    @Nonnull
    public static InputSource create(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        return InputSourceFactory.create(new NonBlockingByteArrayInputStream(byArray, n, n2));
    }

    @Nonnull
    public static InputSource create(@Nonnull CharSequence charSequence) {
        if (charSequence instanceof String) {
            return InputSourceFactory.create((String)charSequence);
        }
        return InputSourceFactory.create(((Object)charSequence).toString());
    }

    @Nonnull
    public static InputSource create(@Nullable InputStream inputStream) {
        return new InputSource(inputStream);
    }

    @Nonnull
    public static InputSource create(@Nullable Reader reader) {
        return new InputSource(reader);
    }
}

