/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.transform;

import com.phloc.commons.io.IInputStreamProvider;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.string.ToStringGenerator;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.transform.stream.StreamSource;

@NotThreadSafe
public class ResourceStreamSource
extends StreamSource {
    private final IInputStreamProvider m_aISP;

    public ResourceStreamSource(@Nonnull IReadableResource iReadableResource) {
        this(iReadableResource, iReadableResource.getResourceID());
    }

    public ResourceStreamSource(@Nonnull IInputStreamProvider iInputStreamProvider, @Nullable String string) {
        if (iInputStreamProvider == null) {
            throw new NullPointerException("resource");
        }
        this.m_aISP = iInputStreamProvider;
        this.setSystemId(string);
    }

    @Override
    public InputStream getInputStream() {
        InputStream inputStream = this.m_aISP.getInputStream();
        if (inputStream == null) {
            throw new IllegalStateException("Failed to open input stream for " + this.m_aISP);
        }
        return inputStream;
    }

    public String toString() {
        return new ToStringGenerator(this).append("ISP", this.m_aISP).append("systemID", this.getSystemId()).toString();
    }
}

