/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.LongCollection;
import org.apache.commons.collections.primitives.LongIterator;

public abstract class AbstractLongCollection
implements LongCollection {
    protected AbstractLongCollection() {
    }

    @Override
    @Nonnull
    public abstract LongIterator iterator();

    @Override
    @Nonnegative
    public abstract int size();

    @Override
    public boolean add(long l) {
        throw new UnsupportedOperationException("add(long) is not supported.");
    }

    @Override
    public boolean addAll(@Nonnull LongCollection longCollection) {
        boolean bl = false;
        LongIterator longIterator = longCollection.iterator();
        while (longIterator.hasNext()) {
            bl |= this.add(longIterator.next());
        }
        return bl;
    }

    @Override
    public void clear() {
        LongIterator longIterator = this.iterator();
        while (longIterator.hasNext()) {
            longIterator.next();
            longIterator.remove();
        }
    }

    @Override
    public boolean contains(long l) {
        LongIterator longIterator = this.iterator();
        while (longIterator.hasNext()) {
            if (longIterator.next() != l) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(@Nonnull LongCollection longCollection) {
        LongIterator longIterator = longCollection.iterator();
        while (longIterator.hasNext()) {
            if (this.contains(longIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size();
    }

    @Override
    public boolean removeElement(long l) {
        LongIterator longIterator = this.iterator();
        while (longIterator.hasNext()) {
            if (longIterator.next() != l) continue;
            longIterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(@Nonnull LongCollection longCollection) {
        boolean bl = false;
        LongIterator longIterator = longCollection.iterator();
        while (longIterator.hasNext()) {
            bl |= this.removeElement(longIterator.next());
        }
        return bl;
    }

    @Override
    public boolean retainAll(@Nonnull LongCollection longCollection) {
        boolean bl = false;
        LongIterator longIterator = this.iterator();
        while (longIterator.hasNext()) {
            if (longCollection.contains(longIterator.next())) continue;
            longIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public long[] toArray() {
        long[] lArray = new long[this.size()];
        int n = 0;
        LongIterator longIterator = this.iterator();
        while (longIterator.hasNext()) {
            lArray[n++] = longIterator.next();
        }
        return lArray;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public long[] toArray(@Nonnull long[] lArray) {
        if (lArray.length < this.size()) {
            return this.toArray();
        }
        int n = 0;
        LongIterator longIterator = this.iterator();
        while (longIterator.hasNext()) {
            lArray[n++] = longIterator.next();
        }
        return lArray;
    }
}

