/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.LongCollection;
import org.apache.commons.collections.primitives.LongIterator;
import org.apache.commons.collections.primitives.RandomAccessLongList;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public class ArrayLongList
extends RandomAccessLongList
implements Serializable {
    private transient long[] _data;
    private int _size;

    public ArrayLongList() {
        this(8);
    }

    public ArrayLongList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("capacity " + n);
        }
        this._data = new long[n];
        this._size = 0;
    }

    public ArrayLongList(@Nonnull LongCollection longCollection) {
        this(longCollection.size());
        this.addAll(longCollection);
    }

    public ArrayLongList(@Nonnull long[] lArray) {
        this(lArray.length);
        System.arraycopy(lArray, 0, this._data, 0, lArray.length);
        this._size = lArray.length;
    }

    @Override
    public long get(int n) {
        this._checkRange(n);
        return this._data[n];
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public long removeElementAt(int n) {
        this._checkRange(n);
        this.incrModCount();
        long l = this._data[n];
        int n2 = this._size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this._data, n + 1, this._data, n, n2);
        }
        --this._size;
        return l;
    }

    @Override
    public long set(int n, long l) {
        this._checkRange(n);
        this.incrModCount();
        long l2 = this._data[n];
        this._data[n] = l;
        return l2;
    }

    @Override
    public void add(int n, long l) {
        this._checkRangeIncludingEndpoint(n);
        this.incrModCount();
        this.ensureCapacity(this._size + 1);
        int n2 = this._size - n;
        System.arraycopy(this._data, n, this._data, n + 1, n2);
        this._data[n] = l;
        ++this._size;
    }

    @Override
    public void clear() {
        this.incrModCount();
        this._size = 0;
    }

    @Override
    public boolean addAll(@Nonnull LongCollection longCollection) {
        return this.addAll(this.size(), longCollection);
    }

    @Override
    public boolean addAll(int n, @Nonnull LongCollection longCollection) {
        if (longCollection.size() == 0) {
            return false;
        }
        int n2 = n;
        this._checkRangeIncludingEndpoint(n2);
        this.incrModCount();
        this.ensureCapacity(this._size + longCollection.size());
        if (n2 != this._size) {
            System.arraycopy(this._data, n2, this._data, n2 + longCollection.size(), this._size - n2);
        }
        LongIterator longIterator = longCollection.iterator();
        while (longIterator.hasNext()) {
            this._data[n2] = longIterator.next();
            ++n2;
        }
        this._size += longCollection.size();
        return true;
    }

    public void ensureCapacity(int n) {
        this.incrModCount();
        if (n > this._data.length) {
            int n2 = this._data.length * 3 / 2 + 1;
            long[] lArray = this._data;
            this._data = new long[n2 < n ? n : n2];
            System.arraycopy(lArray, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        this.incrModCount();
        if (this._size < this._data.length) {
            long[] lArray = this._data;
            this._data = new long[this._size];
            System.arraycopy(lArray, 0, this._data, 0, this._size);
        }
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._data.length);
        for (int i = 0; i < this._size; ++i) {
            objectOutputStream.writeLong(this._data[i]);
        }
    }

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._data = new long[objectInputStream.readInt()];
        for (int i = 0; i < this._size; ++i) {
            this._data[i] = objectInputStream.readLong();
        }
    }

    private final void _checkRange(int n) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this._size + ", found " + n);
        }
    }

    private final void _checkRangeIncludingEndpoint(int n) {
        if (n < 0 || n > this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this._size + ", found " + n);
        }
    }
}

