/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.collections.primitives.RandomAccessShortList;
import org.apache.commons.collections.primitives.ShortCollection;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public class ArrayUnsignedByteList
extends RandomAccessShortList
implements Serializable {
    public static final short MAX_VALUE = 255;
    public static final short MIN_VALUE = 0;
    private transient byte[] _data;
    private int _size;

    public ArrayUnsignedByteList() {
        this(8);
    }

    public ArrayUnsignedByteList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("capacity " + n);
        }
        this._data = new byte[n];
        this._size = 0;
    }

    public ArrayUnsignedByteList(ShortCollection shortCollection) {
        this(shortCollection.size());
        this.addAll(shortCollection);
    }

    public ArrayUnsignedByteList(short[] sArray) {
        this(sArray.length);
        for (int i = 0; i < sArray.length; ++i) {
            this._data[i] = this._fromShort(sArray[i]);
        }
        this._size = sArray.length;
    }

    @Override
    public short get(int n) {
        this._checkRange(n);
        return this._toShort(this._data[n]);
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public short removeElementAt(int n) {
        this._checkRange(n);
        this.incrModCount();
        short s = this._toShort(this._data[n]);
        int n2 = this._size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this._data, n + 1, this._data, n, n2);
        }
        --this._size;
        return s;
    }

    @Override
    public short set(int n, short s) {
        this._assertValidUnsignedByte(s);
        this._checkRange(n);
        this.incrModCount();
        short s2 = this._toShort(this._data[n]);
        this._data[n] = this._fromShort(s);
        return s2;
    }

    @Override
    public void add(int n, short s) {
        this._assertValidUnsignedByte(s);
        this._checkRangeIncludingEndpoint(n);
        this.incrModCount();
        this.ensureCapacity(this._size + 1);
        int n2 = this._size - n;
        System.arraycopy(this._data, n, this._data, n + 1, n2);
        this._data[n] = this._fromShort(s);
        ++this._size;
    }

    @Override
    public void clear() {
        this.incrModCount();
        this._size = 0;
    }

    public void ensureCapacity(int n) {
        this.incrModCount();
        if (n > this._data.length) {
            int n2 = this._data.length * 3 / 2 + 1;
            byte[] byArray = this._data;
            this._data = new byte[n2 < n ? n : n2];
            System.arraycopy(byArray, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        this.incrModCount();
        if (this._size < this._data.length) {
            byte[] byArray = this._data;
            this._data = new byte[this._size];
            System.arraycopy(byArray, 0, this._data, 0, this._size);
        }
    }

    private final short _toShort(byte by) {
        return (short)(by & 0xFF);
    }

    private final byte _fromShort(short s) {
        return (byte)(s & 0xFF);
    }

    private final void _assertValidUnsignedByte(short s) throws IllegalArgumentException {
        if (s > 255) {
            throw new IllegalArgumentException(s + " > " + 255);
        }
        if (s < 0) {
            throw new IllegalArgumentException(s + " < " + 0);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._data.length);
        for (int i = 0; i < this._size; ++i) {
            objectOutputStream.writeByte(this._data[i]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._data = new byte[objectInputStream.readInt()];
        for (int i = 0; i < this._size; ++i) {
            this._data[i] = objectInputStream.readByte();
        }
    }

    private final void _checkRange(int n) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this._size + ", found " + n);
        }
    }

    private final void _checkRangeIncludingEndpoint(int n) {
        if (n < 0 || n > this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this._size + ", found " + n);
        }
    }
}

