/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import java.util.EmptyStackException;
import javax.annotation.Nonnegative;
import org.apache.commons.collections.primitives.ArrayBooleanList;

public class BooleanStack {
    private final ArrayBooleanList m_aList = new ArrayBooleanList();

    public BooleanStack() {
    }

    public BooleanStack(boolean[] blArray) {
        for (boolean bl : blArray) {
            this.m_aList.add(bl);
        }
    }

    @Deprecated
    public boolean empty() {
        return this.isEmpty();
    }

    public boolean isEmpty() {
        return this.m_aList.isEmpty();
    }

    public boolean peek() {
        if (this.m_aList.isEmpty()) {
            throw new EmptyStackException();
        }
        return this.m_aList.get(this.m_aList.size() - 1);
    }

    public boolean peek(int n) {
        if (this.m_aList.isEmpty()) {
            throw new EmptyStackException();
        }
        return this.m_aList.get(this.m_aList.size() - n - 1);
    }

    public boolean pop() {
        if (this.m_aList.isEmpty()) {
            throw new EmptyStackException();
        }
        return this.m_aList.removeElementAt(this.m_aList.size() - 1);
    }

    public boolean push(boolean bl) {
        this.m_aList.add(bl);
        return bl;
    }

    public int search(boolean bl) {
        for (int i = this.m_aList.size() - 1; i >= 0; --i) {
            if (this.m_aList.get(i) != bl) continue;
            return this.m_aList.size() - i;
        }
        return -1;
    }

    public boolean get(int n) {
        return this.m_aList.get(n);
    }

    @Nonnegative
    public int size() {
        return this.m_aList.size();
    }

    public void clear() {
        this.m_aList.clear();
    }
}

