/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import java.util.EmptyStackException;
import javax.annotation.Nonnegative;
import org.apache.commons.collections.primitives.ArrayDoubleList;

public class DoubleStack {
    private final ArrayDoubleList m_aList = new ArrayDoubleList();

    public DoubleStack() {
    }

    public DoubleStack(double[] dArray) {
        for (double d : dArray) {
            this.m_aList.add(d);
        }
    }

    @Deprecated
    public boolean empty() {
        return this.isEmpty();
    }

    public boolean isEmpty() {
        return this.m_aList.isEmpty();
    }

    public double peek() {
        if (this.m_aList.isEmpty()) {
            throw new EmptyStackException();
        }
        return this.m_aList.get(this.m_aList.size() - 1);
    }

    public double peek(int n) {
        if (this.m_aList.isEmpty()) {
            throw new EmptyStackException();
        }
        return this.m_aList.get(this.m_aList.size() - n - 1);
    }

    public double pop() {
        if (this.m_aList.isEmpty()) {
            throw new EmptyStackException();
        }
        return this.m_aList.removeElementAt(this.m_aList.size() - 1);
    }

    public double push(double d) {
        this.m_aList.add(d);
        return d;
    }

    public int search(double d) {
        for (int i = this.m_aList.size() - 1; i >= 0; --i) {
            if (this.m_aList.get(i) != d) continue;
            return this.m_aList.size() - i;
        }
        return -1;
    }

    public double get(int n) {
        return this.m_aList.get(n);
    }

    @Nonnegative
    public int size() {
        return this.m_aList.size();
    }

    public void clear() {
        this.m_aList.clear();
    }
}

