/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import com.phloc.commons.hash.HashCodeGenerator;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.AbstractDoubleCollection;
import org.apache.commons.collections.primitives.DoubleCollection;
import org.apache.commons.collections.primitives.DoubleIterator;
import org.apache.commons.collections.primitives.DoubleList;
import org.apache.commons.collections.primitives.DoubleListIterator;

public abstract class RandomAccessDoubleList
extends AbstractDoubleCollection
implements DoubleList {
    private int _modCount = 0;

    protected RandomAccessDoubleList() {
    }

    @Override
    public abstract double get(int var1);

    @Override
    public abstract int size();

    @Override
    public double removeElementAt(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double set(int n, double d) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int n, double d) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(double d) {
        this.add(this.size(), d);
        return true;
    }

    @Override
    public boolean addAll(int n, @Nonnull DoubleCollection doubleCollection) {
        int n2 = n;
        boolean bl = false;
        DoubleIterator doubleIterator = doubleCollection.iterator();
        while (doubleIterator.hasNext()) {
            this.add(n2++, doubleIterator.next());
            bl = true;
        }
        return bl;
    }

    @Override
    public int indexOf(double d) {
        int n = 0;
        DoubleIterator doubleIterator = this.iterator();
        while (doubleIterator.hasNext()) {
            if (doubleIterator.next() == d) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(double d) {
        DoubleListIterator doubleListIterator = this.listIterator(this.size());
        while (doubleListIterator.hasPrevious()) {
            if (doubleListIterator.previous() != d) continue;
            return doubleListIterator.nextIndex();
        }
        return -1;
    }

    @Override
    public DoubleIterator iterator() {
        return this.listIterator();
    }

    @Override
    public DoubleListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public DoubleListIterator listIterator(int n) {
        return new RandomAccessDoubleListIterator(this, n);
    }

    @Override
    public DoubleList subList(int n, int n2) {
        return new RandomAccessDoubleSubList(this, n, n2);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DoubleList)) {
            return false;
        }
        DoubleList doubleList = (DoubleList)object;
        if (this.size() != doubleList.size()) {
            return false;
        }
        DoubleIterator doubleIterator = doubleList.iterator();
        DoubleIterator doubleIterator2 = this.iterator();
        while (doubleIterator2.hasNext()) {
            if (doubleIterator2.next() == doubleIterator.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(this);
        DoubleIterator doubleIterator = this.iterator();
        while (doubleIterator.hasNext()) {
            hashCodeGenerator.append(doubleIterator.next());
        }
        return hashCodeGenerator.getHashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        DoubleIterator doubleIterator = this.iterator();
        while (doubleIterator.hasNext()) {
            stringBuilder.append(doubleIterator.next());
            if (!doubleIterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    protected int getModCount() {
        return this._modCount;
    }

    protected void incrModCount() {
        ++this._modCount;
    }

    protected static class RandomAccessDoubleSubList
    extends RandomAccessDoubleList {
        private int _offset = 0;
        private int _limit = 0;
        private RandomAccessDoubleList _list = null;
        private ComodChecker _comod = null;

        RandomAccessDoubleSubList(RandomAccessDoubleList randomAccessDoubleList, int n, int n2) {
            if (n < 0 || n2 > randomAccessDoubleList.size()) {
                throw new IndexOutOfBoundsException();
            }
            if (n > n2) {
                throw new IllegalArgumentException();
            }
            this._list = randomAccessDoubleList;
            this._offset = n;
            this._limit = n2 - n;
            this._comod = new ComodChecker(randomAccessDoubleList);
            this._comod.resyncModCount();
        }

        @Override
        public double get(int n) {
            this.checkRange(n);
            this._comod.assertNotComodified();
            return this._list.get(this.toUnderlyingIndex(n));
        }

        @Override
        public double removeElementAt(int n) {
            this.checkRange(n);
            this._comod.assertNotComodified();
            double d = this._list.removeElementAt(this.toUnderlyingIndex(n));
            --this._limit;
            this._comod.resyncModCount();
            this.incrModCount();
            return d;
        }

        @Override
        public double set(int n, double d) {
            this.checkRange(n);
            this._comod.assertNotComodified();
            double d2 = this._list.set(this.toUnderlyingIndex(n), d);
            this.incrModCount();
            this._comod.resyncModCount();
            return d2;
        }

        @Override
        public void add(int n, double d) {
            this.checkRangeIncludingEndpoint(n);
            this._comod.assertNotComodified();
            this._list.add(this.toUnderlyingIndex(n), d);
            ++this._limit;
            this._comod.resyncModCount();
            this.incrModCount();
        }

        @Override
        public int size() {
            this._comod.assertNotComodified();
            return this._limit;
        }

        private void checkRange(int n) {
            if (n < 0 || n >= this.size()) {
                throw new IndexOutOfBoundsException("index " + n + " not in [0," + this.size() + ")");
            }
        }

        private void checkRangeIncludingEndpoint(int n) {
            if (n < 0 || n > this.size()) {
                throw new IndexOutOfBoundsException("index " + n + " not in [0," + this.size() + "]");
            }
        }

        private int toUnderlyingIndex(int n) {
            return n + this._offset;
        }
    }

    protected static class RandomAccessDoubleListIterator
    extends ComodChecker
    implements DoubleListIterator {
        private int _nextIndex = 0;
        private int _lastReturnedIndex = -1;

        RandomAccessDoubleListIterator(RandomAccessDoubleList randomAccessDoubleList, int n) {
            super(randomAccessDoubleList);
            if (n < 0 || n > this.getList().size()) {
                throw new IndexOutOfBoundsException("Index " + n + " not in [0," + this.getList().size() + ")");
            }
            this._nextIndex = n;
            this.resyncModCount();
        }

        @Override
        public boolean hasNext() {
            this.assertNotComodified();
            return this._nextIndex < this.getList().size();
        }

        @Override
        public boolean hasPrevious() {
            this.assertNotComodified();
            return this._nextIndex > 0;
        }

        @Override
        public int nextIndex() {
            this.assertNotComodified();
            return this._nextIndex;
        }

        @Override
        public int previousIndex() {
            this.assertNotComodified();
            return this._nextIndex - 1;
        }

        @Override
        public double next() {
            this.assertNotComodified();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            double d = this.getList().get(this._nextIndex);
            this._lastReturnedIndex = this._nextIndex++;
            return d;
        }

        @Override
        public double previous() {
            this.assertNotComodified();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            double d = this.getList().get(this._nextIndex - 1);
            this._lastReturnedIndex = this._nextIndex - 1;
            --this._nextIndex;
            return d;
        }

        @Override
        public void add(double d) {
            this.assertNotComodified();
            this.getList().add(this._nextIndex, d);
            ++this._nextIndex;
            this._lastReturnedIndex = -1;
            this.resyncModCount();
        }

        @Override
        public void remove() {
            this.assertNotComodified();
            if (this._lastReturnedIndex == -1) {
                throw new IllegalStateException();
            }
            if (this._lastReturnedIndex == this._nextIndex) {
                this.getList().removeElementAt(this._lastReturnedIndex);
            } else {
                this.getList().removeElementAt(this._lastReturnedIndex);
                --this._nextIndex;
            }
            this._lastReturnedIndex = -1;
            this.resyncModCount();
        }

        @Override
        public void set(double d) {
            this.assertNotComodified();
            if (-1 == this._lastReturnedIndex) {
                throw new IllegalStateException();
            }
            this.getList().set(this._lastReturnedIndex, d);
            this.resyncModCount();
        }
    }

    private static class ComodChecker {
        private RandomAccessDoubleList _source = null;
        private int _expectedModCount = -1;

        ComodChecker(RandomAccessDoubleList randomAccessDoubleList) {
            this._source = randomAccessDoubleList;
            this.resyncModCount();
        }

        protected RandomAccessDoubleList getList() {
            return this._source;
        }

        protected void assertNotComodified() throws ConcurrentModificationException {
            if (this._expectedModCount != this.getList().getModCount()) {
                throw new ConcurrentModificationException();
            }
        }

        protected void resyncModCount() {
            this._expectedModCount = this.getList().getModCount();
        }
    }
}

