/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import com.phloc.commons.hash.HashCodeGenerator;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.AbstractIntCollection;
import org.apache.commons.collections.primitives.IntCollection;
import org.apache.commons.collections.primitives.IntIterator;
import org.apache.commons.collections.primitives.IntList;
import org.apache.commons.collections.primitives.IntListIterator;

public abstract class RandomAccessIntList
extends AbstractIntCollection
implements IntList {
    private int _modCount = 0;

    protected RandomAccessIntList() {
    }

    @Override
    public abstract int get(int var1);

    @Override
    public abstract int size();

    @Override
    public int removeElementAt(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int set(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(int n) {
        this.add(this.size(), n);
        return true;
    }

    @Override
    public boolean addAll(int n, @Nonnull IntCollection intCollection) {
        int n2 = n;
        boolean bl = false;
        IntIterator intIterator = intCollection.iterator();
        while (intIterator.hasNext()) {
            this.add(n2++, intIterator.next());
            bl = true;
        }
        return bl;
    }

    @Override
    public int indexOf(int n) {
        int n2 = 0;
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            if (intIterator.next() == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(int n) {
        IntListIterator intListIterator = this.listIterator(this.size());
        while (intListIterator.hasPrevious()) {
            if (intListIterator.previous() != n) continue;
            return intListIterator.nextIndex();
        }
        return -1;
    }

    @Override
    public IntIterator iterator() {
        return this.listIterator();
    }

    @Override
    public IntListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public IntListIterator listIterator(int n) {
        return new RandomAccessIntegerListIterator(this, n);
    }

    @Override
    public IntList subList(int n, int n2) {
        return new RandomAccessIntegerSubList(this, n, n2);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IntList)) {
            return false;
        }
        IntList intList = (IntList)object;
        if (this.size() != intList.size()) {
            return false;
        }
        IntIterator intIterator = intList.iterator();
        IntIterator intIterator2 = this.iterator();
        while (intIterator2.hasNext()) {
            if (intIterator2.next() == intIterator.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(this);
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            hashCodeGenerator.append(intIterator.next());
        }
        return hashCodeGenerator.getHashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            stringBuilder.append(intIterator.next());
            if (!intIterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    protected int getModCount() {
        return this._modCount;
    }

    protected void incrModCount() {
        ++this._modCount;
    }

    protected static class RandomAccessIntegerSubList
    extends RandomAccessIntList {
        private int _offset = 0;
        private int _limit = 0;
        private RandomAccessIntList _list = null;
        private ComodChecker _comod = null;

        RandomAccessIntegerSubList(RandomAccessIntList randomAccessIntList, int n, int n2) {
            if (n < 0 || n2 > randomAccessIntList.size()) {
                throw new IndexOutOfBoundsException();
            }
            if (n > n2) {
                throw new IllegalArgumentException();
            }
            this._list = randomAccessIntList;
            this._offset = n;
            this._limit = n2 - n;
            this._comod = new ComodChecker(randomAccessIntList);
            this._comod.resyncModCount();
        }

        @Override
        public int get(int n) {
            this.checkRange(n);
            this._comod.assertNotComodified();
            return this._list.get(this.toUnderlyingIndex(n));
        }

        @Override
        public int removeElementAt(int n) {
            this.checkRange(n);
            this._comod.assertNotComodified();
            int n2 = this._list.removeElementAt(this.toUnderlyingIndex(n));
            --this._limit;
            this._comod.resyncModCount();
            this.incrModCount();
            return n2;
        }

        @Override
        public int set(int n, int n2) {
            this.checkRange(n);
            this._comod.assertNotComodified();
            int n3 = this._list.set(this.toUnderlyingIndex(n), n2);
            this.incrModCount();
            this._comod.resyncModCount();
            return n3;
        }

        @Override
        public void add(int n, int n2) {
            this.checkRangeIncludingEndpoint(n);
            this._comod.assertNotComodified();
            this._list.add(this.toUnderlyingIndex(n), n2);
            ++this._limit;
            this._comod.resyncModCount();
            this.incrModCount();
        }

        @Override
        public int size() {
            this._comod.assertNotComodified();
            return this._limit;
        }

        private void checkRange(int n) {
            if (n < 0 || n >= this.size()) {
                throw new IndexOutOfBoundsException("index " + n + " not in [0," + this.size() + ")");
            }
        }

        private void checkRangeIncludingEndpoint(int n) {
            if (n < 0 || n > this.size()) {
                throw new IndexOutOfBoundsException("index " + n + " not in [0," + this.size() + "]");
            }
        }

        private int toUnderlyingIndex(int n) {
            return n + this._offset;
        }
    }

    protected static class RandomAccessIntegerListIterator
    extends ComodChecker
    implements IntListIterator {
        private int _nextIndex = 0;
        private int _lastReturnedIndex = -1;

        RandomAccessIntegerListIterator(RandomAccessIntList randomAccessIntList, int n) {
            super(randomAccessIntList);
            if (n < 0 || n > this.getList().size()) {
                throw new IndexOutOfBoundsException("Index " + n + " not in [0," + this.getList().size() + ")");
            }
            this._nextIndex = n;
            this.resyncModCount();
        }

        @Override
        public boolean hasNext() {
            this.assertNotComodified();
            return this._nextIndex < this.getList().size();
        }

        @Override
        public boolean hasPrevious() {
            this.assertNotComodified();
            return this._nextIndex > 0;
        }

        @Override
        public int nextIndex() {
            this.assertNotComodified();
            return this._nextIndex;
        }

        @Override
        public int previousIndex() {
            this.assertNotComodified();
            return this._nextIndex - 1;
        }

        @Override
        public int next() {
            this.assertNotComodified();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int n = this.getList().get(this._nextIndex);
            this._lastReturnedIndex = this._nextIndex++;
            return n;
        }

        @Override
        public int previous() {
            this.assertNotComodified();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            int n = this.getList().get(this._nextIndex - 1);
            this._lastReturnedIndex = this._nextIndex - 1;
            --this._nextIndex;
            return n;
        }

        @Override
        public void add(int n) {
            this.assertNotComodified();
            this.getList().add(this._nextIndex, n);
            ++this._nextIndex;
            this._lastReturnedIndex = -1;
            this.resyncModCount();
        }

        @Override
        public void remove() {
            this.assertNotComodified();
            if (this._lastReturnedIndex == -1) {
                throw new IllegalStateException();
            }
            if (this._lastReturnedIndex == this._nextIndex) {
                this.getList().removeElementAt(this._lastReturnedIndex);
            } else {
                this.getList().removeElementAt(this._lastReturnedIndex);
                --this._nextIndex;
            }
            this._lastReturnedIndex = -1;
            this.resyncModCount();
        }

        @Override
        public void set(int n) {
            this.assertNotComodified();
            if (-1 == this._lastReturnedIndex) {
                throw new IllegalStateException();
            }
            this.getList().set(this._lastReturnedIndex, n);
            this.resyncModCount();
        }
    }

    private static class ComodChecker {
        private RandomAccessIntList _source = null;
        private int _expectedModCount = -1;

        ComodChecker(RandomAccessIntList randomAccessIntList) {
            this._source = randomAccessIntList;
            this.resyncModCount();
        }

        protected RandomAccessIntList getList() {
            return this._source;
        }

        protected void assertNotComodified() throws ConcurrentModificationException {
            if (this._expectedModCount != this.getList().getModCount()) {
                throw new ConcurrentModificationException();
            }
        }

        protected void resyncModCount() {
            this._expectedModCount = this.getList().getModCount();
        }
    }
}

