/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import java.util.Collection;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.ByteCollection;
import org.apache.commons.collections.primitives.ByteIterator;
import org.apache.commons.collections.primitives.adapters.ByteCollectionCollection;
import org.apache.commons.collections.primitives.adapters.IteratorByteIterator;

abstract class AbstractCollectionByteCollection
implements ByteCollection {
    protected AbstractCollectionByteCollection() {
    }

    @Nonnull
    protected abstract Collection<Byte> getCollection();

    @Override
    public boolean add(byte by) {
        return this.getCollection().add(by);
    }

    @Override
    public boolean addAll(@Nonnull ByteCollection byteCollection) {
        return this.getCollection().addAll(ByteCollectionCollection.wrap(byteCollection));
    }

    @Override
    public void clear() {
        this.getCollection().clear();
    }

    @Override
    public boolean contains(byte by) {
        return this.getCollection().contains(by);
    }

    @Override
    public boolean containsAll(@Nonnull ByteCollection byteCollection) {
        return this.getCollection().containsAll(ByteCollectionCollection.wrap(byteCollection));
    }

    @Override
    public boolean isEmpty() {
        return this.getCollection().isEmpty();
    }

    @Override
    @Nonnull
    public ByteIterator iterator() {
        return IteratorByteIterator.wrap(this.getCollection().iterator());
    }

    @Override
    public boolean removeElement(byte by) {
        return this.getCollection().remove(by);
    }

    @Override
    public boolean removeAll(@Nonnull ByteCollection byteCollection) {
        return this.getCollection().removeAll(ByteCollectionCollection.wrap(byteCollection));
    }

    @Override
    public boolean retainAll(@Nonnull ByteCollection byteCollection) {
        return this.getCollection().retainAll(ByteCollectionCollection.wrap(byteCollection));
    }

    @Override
    @Nonnegative
    public int size() {
        return this.getCollection().size();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public byte[] toArray() {
        Object[] objectArray = this.getCollection().toArray();
        byte[] byArray = new byte[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            byArray[i] = (Byte)objectArray[i];
        }
        return byArray;
    }

    @Override
    @Nonnull
    public byte[] toArray(@Nonnull byte[] byArray) {
        byte[] byArray2 = byArray;
        Object[] objectArray = this.getCollection().toArray();
        if (byArray2.length < objectArray.length) {
            byArray2 = new byte[objectArray.length];
        }
        for (int i = 0; i < objectArray.length; ++i) {
            byArray2[i] = (Byte)objectArray[i];
        }
        return byArray2;
    }

    public String toString() {
        return this.getCollection().toString();
    }
}

