/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import java.util.Collection;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.IntCollection;
import org.apache.commons.collections.primitives.IntIterator;
import org.apache.commons.collections.primitives.adapters.IntCollectionCollection;
import org.apache.commons.collections.primitives.adapters.IteratorIntIterator;

abstract class AbstractCollectionIntCollection
implements IntCollection {
    protected AbstractCollectionIntCollection() {
    }

    @Nonnull
    protected abstract Collection<Integer> getCollection();

    @Override
    public boolean add(int n) {
        return this.getCollection().add(n);
    }

    @Override
    public boolean addAll(@Nonnull IntCollection intCollection) {
        return this.getCollection().addAll(IntCollectionCollection.wrap(intCollection));
    }

    @Override
    public void clear() {
        this.getCollection().clear();
    }

    @Override
    public boolean contains(int n) {
        return this.getCollection().contains(n);
    }

    @Override
    public boolean containsAll(@Nonnull IntCollection intCollection) {
        return this.getCollection().containsAll(IntCollectionCollection.wrap(intCollection));
    }

    @Override
    public boolean isEmpty() {
        return this.getCollection().isEmpty();
    }

    @Override
    @Nonnull
    public IntIterator iterator() {
        return IteratorIntIterator.wrap(this.getCollection().iterator());
    }

    @Override
    public boolean removeElement(int n) {
        return this.getCollection().remove(n);
    }

    @Override
    public boolean removeAll(@Nonnull IntCollection intCollection) {
        return this.getCollection().removeAll(IntCollectionCollection.wrap(intCollection));
    }

    @Override
    public boolean retainAll(@Nonnull IntCollection intCollection) {
        return this.getCollection().retainAll(IntCollectionCollection.wrap(intCollection));
    }

    @Override
    @Nonnegative
    public int size() {
        return this.getCollection().size();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public int[] toArray() {
        Object[] objectArray = this.getCollection().toArray();
        int[] nArray = new int[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            nArray[i] = (Integer)objectArray[i];
        }
        return nArray;
    }

    @Override
    @Nonnull
    public int[] toArray(@Nonnull int[] nArray) {
        int[] nArray2 = nArray;
        Object[] objectArray = this.getCollection().toArray();
        if (nArray2.length < objectArray.length) {
            nArray2 = new int[objectArray.length];
        }
        for (int i = 0; i < objectArray.length; ++i) {
            nArray2[i] = (Integer)objectArray[i];
        }
        return nArray2;
    }

    public String toString() {
        return this.getCollection().toString();
    }
}

