/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import java.util.Collection;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.LongCollection;
import org.apache.commons.collections.primitives.LongIterator;
import org.apache.commons.collections.primitives.adapters.IteratorLongIterator;
import org.apache.commons.collections.primitives.adapters.LongCollectionCollection;

abstract class AbstractCollectionLongCollection
implements LongCollection {
    protected AbstractCollectionLongCollection() {
    }

    @Nonnull
    protected abstract Collection<Long> getCollection();

    @Override
    public boolean add(long l) {
        return this.getCollection().add(l);
    }

    @Override
    public boolean addAll(@Nonnull LongCollection longCollection) {
        return this.getCollection().addAll(LongCollectionCollection.wrap(longCollection));
    }

    @Override
    public void clear() {
        this.getCollection().clear();
    }

    @Override
    public boolean contains(long l) {
        return this.getCollection().contains(l);
    }

    @Override
    public boolean containsAll(@Nonnull LongCollection longCollection) {
        return this.getCollection().containsAll(LongCollectionCollection.wrap(longCollection));
    }

    @Override
    public boolean isEmpty() {
        return this.getCollection().isEmpty();
    }

    @Override
    @Nonnull
    public LongIterator iterator() {
        return IteratorLongIterator.wrap(this.getCollection().iterator());
    }

    @Override
    public boolean removeElement(long l) {
        return this.getCollection().remove(l);
    }

    @Override
    public boolean removeAll(@Nonnull LongCollection longCollection) {
        return this.getCollection().removeAll(LongCollectionCollection.wrap(longCollection));
    }

    @Override
    public boolean retainAll(@Nonnull LongCollection longCollection) {
        return this.getCollection().retainAll(LongCollectionCollection.wrap(longCollection));
    }

    @Override
    @Nonnegative
    public int size() {
        return this.getCollection().size();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public long[] toArray() {
        Object[] objectArray = this.getCollection().toArray();
        long[] lArray = new long[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            lArray[i] = (Long)objectArray[i];
        }
        return lArray;
    }

    @Override
    @Nonnull
    public long[] toArray(@Nonnull long[] lArray) {
        long[] lArray2 = lArray;
        Object[] objectArray = this.getCollection().toArray();
        if (lArray2.length < objectArray.length) {
            lArray2 = new long[objectArray.length];
        }
        for (int i = 0; i < objectArray.length; ++i) {
            lArray2[i] = (Long)objectArray[i];
        }
        return lArray2;
    }

    public String toString() {
        return this.getCollection().toString();
    }
}

