/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.DoubleCollection;
import org.apache.commons.collections.primitives.adapters.CollectionDoubleCollection;
import org.apache.commons.collections.primitives.adapters.DoubleIteratorIterator;

abstract class AbstractDoubleCollectionCollection
implements Collection<Double> {
    AbstractDoubleCollectionCollection() {
    }

    @Nonnull
    protected abstract DoubleCollection getDoubleCollection();

    @Override
    public boolean add(Double d) {
        return this.getDoubleCollection().add(d);
    }

    @Override
    public boolean addAll(Collection<? extends Double> collection) {
        return this.getDoubleCollection().addAll(CollectionDoubleCollection.wrap(collection));
    }

    @Override
    public void clear() {
        this.getDoubleCollection().clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.getDoubleCollection().contains((Double)object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.getDoubleCollection().containsAll(CollectionDoubleCollection.wrap(collection));
    }

    public String toString() {
        return this.getDoubleCollection().toString();
    }

    @Override
    public boolean isEmpty() {
        return this.getDoubleCollection().isEmpty();
    }

    @Override
    public Iterator<Double> iterator() {
        return DoubleIteratorIterator.wrap(this.getDoubleCollection().iterator());
    }

    @Override
    public boolean remove(Object object) {
        return this.getDoubleCollection().removeElement((Double)object);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.getDoubleCollection().removeAll(CollectionDoubleCollection.wrap(collection));
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.getDoubleCollection().retainAll(CollectionDoubleCollection.wrap(collection));
    }

    @Override
    public int size() {
        return this.getDoubleCollection().size();
    }

    @Nonnull
    @ReturnsMutableCopy
    public Double[] toArray() {
        double[] dArray = this.getDoubleCollection().toArray();
        Double[] doubleArray = new Double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            doubleArray[i] = dArray[i];
        }
        return doubleArray;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        Double[] doubleArray = this.toArray();
        int n = this.size();
        if (TArray.length < n) {
            return Arrays.copyOf(doubleArray, n, TArray.getClass());
        }
        System.arraycopy(doubleArray, 0, TArray, 0, n);
        if (TArray.length > n) {
            TArray[n] = null;
        }
        return TArray;
    }
}

