/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.apache.commons.collections.primitives.IntCollection;
import org.apache.commons.collections.primitives.adapters.CollectionIntCollection;
import org.apache.commons.collections.primitives.adapters.IntIteratorIterator;

abstract class AbstractIntCollectionCollection
implements Collection<Integer> {
    AbstractIntCollectionCollection() {
    }

    @Nonnull
    protected abstract IntCollection getIntCollection();

    @Override
    public boolean add(Integer n) {
        return this.getIntCollection().add(n);
    }

    @Override
    public boolean addAll(Collection<? extends Integer> collection) {
        return this.getIntCollection().addAll(CollectionIntCollection.wrap(collection));
    }

    @Override
    public void clear() {
        this.getIntCollection().clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.getIntCollection().contains((Integer)object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.getIntCollection().containsAll(CollectionIntCollection.wrap(collection));
    }

    public String toString() {
        return this.getIntCollection().toString();
    }

    @Override
    public boolean isEmpty() {
        return this.getIntCollection().isEmpty();
    }

    @Override
    public Iterator<Integer> iterator() {
        return IntIteratorIterator.wrap(this.getIntCollection().iterator());
    }

    @Override
    public boolean remove(Object object) {
        return this.getIntCollection().removeElement((Integer)object);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.getIntCollection().removeAll(CollectionIntCollection.wrap(collection));
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.getIntCollection().retainAll(CollectionIntCollection.wrap(collection));
    }

    @Override
    public int size() {
        return this.getIntCollection().size();
    }

    @Nonnull
    @ReturnsMutableCopy
    public Integer[] toArray() {
        int[] nArray = this.getIntCollection().toArray();
        Integer[] integerArray = new Integer[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            integerArray[i] = nArray[i];
        }
        return integerArray;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        Integer[] integerArray = this.toArray();
        int n = this.size();
        if (TArray.length < n) {
            return Arrays.copyOf(integerArray, n, TArray.getClass());
        }
        System.arraycopy(integerArray, 0, TArray, 0, n);
        if (TArray.length > n) {
            TArray[n] = null;
        }
        return TArray;
    }
}

