/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.adapters;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.CharCollection;
import org.apache.commons.collections.primitives.adapters.AbstractCharCollectionCollection;
import org.apache.commons.collections.primitives.adapters.NonSerializableCharCollectionCollection;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public final class CharCollectionCollection
extends AbstractCharCollectionCollection
implements Serializable {
    private transient CharCollection m_aCollection;

    public CharCollectionCollection(@Nonnull CharCollection charCollection) {
        this.m_aCollection = charCollection;
    }

    @Override
    @Nonnull
    protected CharCollection getCharCollection() {
        return this.m_aCollection;
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.m_aCollection);
    }

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.m_aCollection = (CharCollection)objectInputStream.readObject();
    }

    @Nullable
    public static Collection<Character> wrap(@Nullable CharCollection charCollection) {
        if (null == charCollection) {
            return null;
        }
        if (charCollection instanceof Serializable) {
            return new CharCollectionCollection(charCollection);
        }
        return new NonSerializableCharCollectionCollection(charCollection);
    }
}

