/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives.decorators;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.primitives.ByteIterator;
import org.apache.commons.collections.primitives.decorators.ProxyByteIterator;

public final class UnmodifiableByteIterator
extends ProxyByteIterator {
    private ByteIterator m_aProxied;

    UnmodifiableByteIterator(@Nonnull ByteIterator byteIterator) {
        this.m_aProxied = byteIterator;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This ByteIterator is not modifiable.");
    }

    @Override
    @Nonnull
    protected ByteIterator getIterator() {
        return this.m_aProxied;
    }

    @Nullable
    public static final ByteIterator wrap(@Nullable ByteIterator byteIterator) {
        if (null == byteIterator) {
            return null;
        }
        if (byteIterator instanceof UnmodifiableByteIterator) {
            return byteIterator;
        }
        return new UnmodifiableByteIterator(byteIterator);
    }
}

